<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNota ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNota
 * @subpackage Arrays
 */
class ArrayOfNota extends AbstractStructArrayBase
{
    /**
     * The Nota
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Nota[]
     */
    public $Nota;
    /**
     * Constructor method for ArrayOfNota
     * @uses ArrayOfNota::setNota()
     * @param \StructType\Nota[] $nota
     */
    public function __construct(array $nota = array())
    {
        $this
            ->setNota($nota);
    }
    /**
     * Get Nota value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Nota[]|null
     */
    public function getNota()
    {
        return isset($this->Nota) ? $this->Nota : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNota method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNota method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotaForArrayConstraintsFromSetNota(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNotaNotaItem) {
            // validation for constraint: itemType
            if (!$arrayOfNotaNotaItem instanceof \StructType\Nota) {
                $invalidValues[] = is_object($arrayOfNotaNotaItem) ? get_class($arrayOfNotaNotaItem) : sprintf('%s(%s)', gettype($arrayOfNotaNotaItem), var_export($arrayOfNotaNotaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Nota property can only contain items of type \StructType\Nota, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Nota value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Nota[] $nota
     * @return \ArrayType\ArrayOfNota
     */
    public function setNota(array $nota = array())
    {
        // validation for constraint: array
        if ('' !== ($notaArrayErrorMessage = self::validateNotaForArrayConstraintsFromSetNota($nota))) {
            throw new \InvalidArgumentException($notaArrayErrorMessage, __LINE__);
        }
        if (is_null($nota) || (is_array($nota) && empty($nota))) {
            unset($this->Nota);
        } else {
            $this->Nota = $nota;
        }
        return $this;
    }
    /**
     * Add item to Nota value
     * @throws \InvalidArgumentException
     * @param \StructType\Nota $item
     * @return \ArrayType\ArrayOfNota
     */
    public function addToNota(\StructType\Nota $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Nota) {
            throw new \InvalidArgumentException(sprintf('The Nota property can only contain items of type \StructType\Nota, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Nota[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Nota|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Nota|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Nota|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Nota|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Nota|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Nota
     */
    public function getAttributeName()
    {
        return 'Nota';
    }
}
