<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Estado ServiceType
 * @subpackage Services
 */
class Estado extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EstadoDocumento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstadoDocumento $parameters
     * @return \StructType\EstadoDocumentoResponse|bool
     */
    public function EstadoDocumento(\StructType\EstadoDocumento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstadoDocumento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EstadoDocumentoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
