<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPeriodo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPeriodo
 * @subpackage Arrays
 */
class ArrayOfPeriodo extends AbstractStructArrayBase
{
    /**
     * The Periodo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Periodo[]
     */
    public $Periodo;
    /**
     * Constructor method for ArrayOfPeriodo
     * @uses ArrayOfPeriodo::setPeriodo()
     * @param \StructType\Periodo[] $periodo
     */
    public function __construct(array $periodo = array())
    {
        $this
            ->setPeriodo($periodo);
    }
    /**
     * Get Periodo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Periodo[]|null
     */
    public function getPeriodo()
    {
        return isset($this->Periodo) ? $this->Periodo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPeriodo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPeriodo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePeriodoForArrayConstraintsFromSetPeriodo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPeriodoPeriodoItem) {
            // validation for constraint: itemType
            if (!$arrayOfPeriodoPeriodoItem instanceof \StructType\Periodo) {
                $invalidValues[] = is_object($arrayOfPeriodoPeriodoItem) ? get_class($arrayOfPeriodoPeriodoItem) : sprintf('%s(%s)', gettype($arrayOfPeriodoPeriodoItem), var_export($arrayOfPeriodoPeriodoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Periodo property can only contain items of type \StructType\Periodo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Periodo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Periodo[] $periodo
     * @return \ArrayType\ArrayOfPeriodo
     */
    public function setPeriodo(array $periodo = array())
    {
        // validation for constraint: array
        if ('' !== ($periodoArrayErrorMessage = self::validatePeriodoForArrayConstraintsFromSetPeriodo($periodo))) {
            throw new \InvalidArgumentException($periodoArrayErrorMessage, __LINE__);
        }
        if (is_null($periodo) || (is_array($periodo) && empty($periodo))) {
            unset($this->Periodo);
        } else {
            $this->Periodo = $periodo;
        }
        return $this;
    }
    /**
     * Add item to Periodo value
     * @throws \InvalidArgumentException
     * @param \StructType\Periodo $item
     * @return \ArrayType\ArrayOfPeriodo
     */
    public function addToPeriodo(\StructType\Periodo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Periodo) {
            throw new \InvalidArgumentException(sprintf('The Periodo property can only contain items of type \StructType\Periodo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Periodo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Periodo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Periodo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Periodo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Periodo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Periodo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Periodo
     */
    public function getAttributeName()
    {
        return 'Periodo';
    }
}
