<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfComision ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfComision
 * @subpackage Arrays
 */
class ArrayOfComision extends AbstractStructArrayBase
{
    /**
     * The Comision
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Comision[]
     */
    public $Comision;
    /**
     * Constructor method for ArrayOfComision
     * @uses ArrayOfComision::setComision()
     * @param \StructType\Comision[] $comision
     */
    public function __construct(array $comision = array())
    {
        $this
            ->setComision($comision);
    }
    /**
     * Get Comision value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Comision[]|null
     */
    public function getComision()
    {
        return isset($this->Comision) ? $this->Comision : null;
    }
    /**
     * This method is responsible for validating the values passed to the setComision method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComision method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateComisionForArrayConstraintsFromSetComision(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfComisionComisionItem) {
            // validation for constraint: itemType
            if (!$arrayOfComisionComisionItem instanceof \StructType\Comision) {
                $invalidValues[] = is_object($arrayOfComisionComisionItem) ? get_class($arrayOfComisionComisionItem) : sprintf('%s(%s)', gettype($arrayOfComisionComisionItem), var_export($arrayOfComisionComisionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Comision property can only contain items of type \StructType\Comision, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Comision value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Comision[] $comision
     * @return \ArrayType\ArrayOfComision
     */
    public function setComision(array $comision = array())
    {
        // validation for constraint: array
        if ('' !== ($comisionArrayErrorMessage = self::validateComisionForArrayConstraintsFromSetComision($comision))) {
            throw new \InvalidArgumentException($comisionArrayErrorMessage, __LINE__);
        }
        if (is_null($comision) || (is_array($comision) && empty($comision))) {
            unset($this->Comision);
        } else {
            $this->Comision = $comision;
        }
        return $this;
    }
    /**
     * Add item to Comision value
     * @throws \InvalidArgumentException
     * @param \StructType\Comision $item
     * @return \ArrayType\ArrayOfComision
     */
    public function addToComision(\StructType\Comision $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Comision) {
            throw new \InvalidArgumentException(sprintf('The Comision property can only contain items of type \StructType\Comision, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Comision[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Comision|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Comision|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Comision|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Comision|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Comision|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Comision
     */
    public function getAttributeName()
    {
        return 'Comision';
    }
}
