<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkVat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckVat $parameters
     * @return \StructType\CheckVatResponse|bool
     */
    public function checkVat(\StructType\CheckVat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkVat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkVatApprox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckVatApprox $parameters
     * @return \StructType\CheckVatApproxResponse|bool
     */
    public function checkVatApprox(\StructType\CheckVatApprox $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkVatApprox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CheckVatApproxResponse|\StructType\CheckVatResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
