<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rg ServiceType
 * @subpackage Services
 */
class Rg extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named rgWsPublicAfmMethod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RgWsPublicInputRtUser $rgWsPublicInputRt_in
     * @param \StructType\RgWsPublicBasicRtUser $rgWsPublicBasicRt_out
     * @param \ArrayType\RgWsPublicFirmActRtUserArray $arrayOfRgWsPublicFirmActRt_out
     * @param string $pCallSeqId_out
     * @param \StructType\GenWsErrorRtUser $pErrorRec_out
     * @return array|bool
     */
    public function rgWsPublicAfmMethod(\StructType\RgWsPublicInputRtUser $rgWsPublicInputRt_in, \StructType\RgWsPublicBasicRtUser $rgWsPublicBasicRt_out, \ArrayType\RgWsPublicFirmActRtUserArray $arrayOfRgWsPublicFirmActRt_out, $pCallSeqId_out, \StructType\GenWsErrorRtUser $pErrorRec_out)
    {
        try {
            $this->setResult($this->getSoapClient()->rgWsPublicAfmMethod($rgWsPublicInputRt_in, $rgWsPublicBasicRt_out, $arrayOfRgWsPublicFirmActRt_out, $pCallSeqId_out, $pErrorRec_out));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named rgWsPublicVersionInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function rgWsPublicVersionInfo()
    {
        try {
            $this->setResult($this->getSoapClient()->rgWsPublicVersionInfo());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
