<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www1.gsis.gr/webtax2/wsgsis/RgWsPublic/RgWsPublicPort?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www1.gsis.gr/webtax2/wsgsis/RgWsPublic/RgWsPublicPort?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Rg ServiceType
 */
$rg = new \ServiceType\Rg($options);
/**
 * Sample call for rgWsPublicAfmMethod operation/method
 */
if ($rg->rgWsPublicAfmMethod(new \StructType\RgWsPublicInputRtUser(), new \StructType\RgWsPublicBasicRtUser(), new \ArrayType\RgWsPublicFirmActRtUserArray(), $pCallSeqId_out, new \StructType\GenWsErrorRtUser()) !== false) {
    print_r($rg->getResult());
} else {
    print_r($rg->getLastError());
}
/**
 * Sample call for rgWsPublicVersionInfo operation/method
 */
if ($rg->rgWsPublicVersionInfo() !== false) {
    print_r($rg->getResult());
} else {
    print_r($rg->getLastError());
}
