<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskType StructType
 * Meta information extracted from the WSDL
 * - documentation: Class representing TaskType XSD Type: Task
 * @subpackage Structs
 */
class TaskType extends AbstractStructBase
{
    /**
     * The taskType
     * Meta information extracted from the WSDL
     * - documentation: como referencedNotificationID
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $taskType;
    /**
     * The serverTaskID
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $serverTaskID;
    /**
     * Constructor method for TaskType
     * @uses TaskType::setTaskType()
     * @uses TaskType::setServerTaskID()
     * @param string $taskType
     * @param int $serverTaskID
     */
    public function __construct($taskType = null, $serverTaskID = null)
    {
        $this
            ->setTaskType($taskType)
            ->setServerTaskID($serverTaskID);
    }
    /**
     * Get taskType value
     * @return string
     */
    public function getTaskType()
    {
        return $this->taskType;
    }
    /**
     * Set taskType value
     * @param string $taskType
     * @return \StructType\TaskType
     */
    public function setTaskType($taskType = null)
    {
        // validation for constraint: string
        if (!is_null($taskType) && !is_string($taskType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taskType, true), gettype($taskType)), __LINE__);
        }
        $this->taskType = $taskType;
        return $this;
    }
    /**
     * Get serverTaskID value
     * @return int
     */
    public function getServerTaskID()
    {
        return $this->serverTaskID;
    }
    /**
     * Set serverTaskID value
     * @param int $serverTaskID
     * @return \StructType\TaskType
     */
    public function setServerTaskID($serverTaskID = null)
    {
        // validation for constraint: int
        if (!is_null($serverTaskID) && !(is_int($serverTaskID) || ctype_digit($serverTaskID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serverTaskID, true), gettype($serverTaskID)), __LINE__);
        }
        $this->serverTaskID = $serverTaskID;
        return $this;
    }
}
