<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FillEventType StructType
 * Meta information extracted from the WSDL
 * - documentation: Class representing FillEventType XSD Type: FillEvent
 * @subpackage Structs
 */
class FillEventType extends AbstractStructBase
{
    /**
     * The fillEventType
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $fillEventType;
    /**
     * The threshold
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $threshold;
    /**
     * Constructor method for FillEventType
     * @uses FillEventType::setFillEventType()
     * @uses FillEventType::setThreshold()
     * @param string $fillEventType
     * @param int $threshold
     */
    public function __construct($fillEventType = null, $threshold = null)
    {
        $this
            ->setFillEventType($fillEventType)
            ->setThreshold($threshold);
    }
    /**
     * Get fillEventType value
     * @return string
     */
    public function getFillEventType()
    {
        return $this->fillEventType;
    }
    /**
     * Set fillEventType value
     * @param string $fillEventType
     * @return \StructType\FillEventType
     */
    public function setFillEventType($fillEventType = null)
    {
        // validation for constraint: string
        if (!is_null($fillEventType) && !is_string($fillEventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fillEventType, true), gettype($fillEventType)), __LINE__);
        }
        $this->fillEventType = $fillEventType;
        return $this;
    }
    /**
     * Get threshold value
     * @return int
     */
    public function getThreshold()
    {
        return $this->threshold;
    }
    /**
     * Set threshold value
     * @param int $threshold
     * @return \StructType\FillEventType
     */
    public function setThreshold($threshold = null)
    {
        // validation for constraint: int
        if (!is_null($threshold) && !(is_int($threshold) || ctype_digit($threshold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($threshold, true), gettype($threshold)), __LINE__);
        }
        $this->threshold = $threshold;
        return $this;
    }
}
