<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getBinData
     * Meta information extracted from the WSDL
     * - documentation: Gets as binData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return mixed|bool
     */
    public function getBinData()
    {
        try {
            $this->setResult($this->getSoapClient()->getBinData());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCameraImages
     * Meta information extracted from the WSDL
     * - documentation: Gets as cameraImages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\BinaryDataType|bool
     */
    public function getCameraImages()
    {
        try {
            $this->setResult($this->getSoapClient()->getCameraImages());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEvalMap
     * Meta information extracted from the WSDL
     * - documentation: Gets as evalMap
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\BinaryDataType|bool
     */
    public function getEvalMap()
    {
        try {
            $this->setResult($this->getSoapClient()->getEvalMap());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIsBlocked
     * Meta information extracted from the WSDL
     * - documentation: Gets as isBlocked
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return bool|bool
     */
    public function getIsBlocked()
    {
        try {
            $this->setResult($this->getSoapClient()->getIsBlocked());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClearZoneId
     * Meta information extracted from the WSDL
     * - documentation: Gets as clearZoneId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\ClearZoneIDType|bool
     */
    public function getClearZoneId()
    {
        try {
            $this->setResult($this->getSoapClient()->getClearZoneId());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getX
     * Meta information extracted from the WSDL
     * - documentation: Gets as x
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return int|bool
     */
    public function getX()
    {
        try {
            $this->setResult($this->getSoapClient()->getX());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getY
     * Meta information extracted from the WSDL
     * - documentation: Gets as y
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return int|bool
     */
    public function getY()
    {
        try {
            $this->setResult($this->getSoapClient()->getY());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getZ
     * Meta information extracted from the WSDL
     * - documentation: Gets as z
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return int|bool
     */
    public function getZ()
    {
        try {
            $this->setResult($this->getSoapClient()->getZ());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCountIn
     * Meta information extracted from the WSDL
     * - documentation: Gets as countIn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return int|bool
     */
    public function getCountIn()
    {
        try {
            $this->setResult($this->getSoapClient()->getCountIn());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCountOut
     * Meta information extracted from the WSDL
     * - documentation: Gets as countOut
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return int|bool
     */
    public function getCountOut()
    {
        try {
            $this->setResult($this->getSoapClient()->getCountOut());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCountingGateId
     * Meta information extracted from the WSDL
     * - documentation: Gets as countingGateId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\CountingGateIDType|bool
     */
    public function getCountingGateId()
    {
        try {
            $this->setResult($this->getSoapClient()->getCountingGateId());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObj
     * Meta information extracted from the WSDL
     * - documentation: Gets as obj
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\CurrentObjectType[]|bool
     */
    public function getObj()
    {
        try {
            $this->setResult($this->getSoapClient()->getObj());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBinaryData
     * Meta information extracted from the WSDL
     * - documentation: Gets as binaryData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\BinaryDataType|bool
     */
    public function getBinaryData()
    {
        try {
            $this->setResult($this->getSoapClient()->getBinaryData());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPos
     * Meta information extracted from the WSDL
     * - documentation: Gets as pos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\Coordinate3DType|bool
     */
    public function getPos()
    {
        try {
            $this->setResult($this->getSoapClient()->getPos());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMov
     * Meta information extracted from the WSDL
     * - documentation: Gets as mov
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\Coordinate2DType|bool
     */
    public function getMov()
    {
        try {
            $this->setResult($this->getSoapClient()->getMov());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getActivityState
     * Meta information extracted from the WSDL
     * - documentation: Gets as activityState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return bool|bool
     */
    public function getActivityState()
    {
        try {
            $this->setResult($this->getSoapClient()->getActivityState());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getValue
     * Meta information extracted from the WSDL
     * - documentation: Gets as value
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getValue()
    {
        try {
            $this->setResult($this->getSoapClient()->getValue());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDigitalInputPort
     * Meta information extracted from the WSDL
     * - documentation: Gets as digitalInputPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\DigitalInputElementType[]|bool
     */
    public function getDigitalInputPort()
    {
        try {
            $this->setResult($this->getSoapClient()->getDigitalInputPort());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getErrorReason
     * Meta information extracted from the WSDL
     * - documentation: Gets as errorReason
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getErrorReason()
    {
        try {
            $this->setResult($this->getSoapClient()->getErrorReason());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getErrorText
     * Meta information extracted from the WSDL
     * - documentation: Gets as errorText
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getErrorText()
    {
        try {
            $this->setResult($this->getSoapClient()->getErrorText());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getErrorLogData
     * Meta information extracted from the WSDL
     * - documentation: Gets as errorLogData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\BinaryDataType|bool
     */
    public function getErrorLogData()
    {
        try {
            $this->setResult($this->getSoapClient()->getErrorLogData());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIpAddress
     * Meta information extracted from the WSDL
     * - documentation: Gets as ipAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getIpAddress()
    {
        try {
            $this->setResult($this->getSoapClient()->getIpAddress());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFirmwareVersion
     * Meta information extracted from the WSDL
     * - documentation: Gets as firmwareVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getFirmwareVersion()
    {
        try {
            $this->setResult($this->getSoapClient()->getFirmwareVersion());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomerVersion
     * Meta information extracted from the WSDL
     * - documentation: Gets as customerVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getCustomerVersion()
    {
        try {
            $this->setResult($this->getSoapClient()->getCustomerVersion());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFillLevel
     * Meta information extracted from the WSDL
     * - documentation: Gets as fillLevel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return int|bool
     */
    public function getFillLevel()
    {
        try {
            $this->setResult($this->getSoapClient()->getFillLevel());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFillRegionId
     * Meta information extracted from the WSDL
     * - documentation: Gets as fillRegionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\FillRegionIDType|bool
     */
    public function getFillRegionId()
    {
        try {
            $this->setResult($this->getSoapClient()->getFillRegionId());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLostCount
     * Meta information extracted from the WSDL
     * - documentation: Gets as lostCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return int|bool
     */
    public function getLostCount()
    {
        try {
            $this->setResult($this->getSoapClient()->getLostCount());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getExitTime
     * Meta information extracted from the WSDL
     * - documentation: Gets as exitTime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \DateTime|bool
     */
    public function getExitTime()
    {
        try {
            $this->setResult($this->getSoapClient()->getExitTime());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHeight
     * Meta information extracted from the WSDL
     * - documentation: Gets as height
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return int|bool
     */
    public function getHeight()
    {
        try {
            $this->setResult($this->getSoapClient()->getHeight());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getExit
     * Meta information extracted from the WSDL
     * - documentation: Gets as exit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\Coordinate3DType|bool
     */
    public function getExit()
    {
        try {
            $this->setResult($this->getSoapClient()->getExit());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLogData
     * Meta information extracted from the WSDL
     * - documentation: Gets as logData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\BinaryDataType|bool
     */
    public function getLogData()
    {
        try {
            $this->setResult($this->getSoapClient()->getLogData());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMacAddress
     * Meta information extracted from the WSDL
     * - documentation: Gets as macAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getMacAddress()
    {
        try {
            $this->setResult($this->getSoapClient()->getMacAddress());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomerID
     * Meta information extracted from the WSDL
     * - documentation: Gets as customerID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getCustomerID()
    {
        try {
            $this->setResult($this->getSoapClient()->getCustomerID());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTaskType
     * Meta information extracted from the WSDL
     * - documentation: Gets as taskType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getTaskType()
    {
        try {
            $this->setResult($this->getSoapClient()->getTaskType());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNotificationID
     * Meta information extracted from the WSDL
     * - documentation: Gets as notificationID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return int|bool
     */
    public function getNotificationID()
    {
        try {
            $this->setResult($this->getSoapClient()->getNotificationID());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServerTaskID
     * Meta information extracted from the WSDL
     * - documentation: Gets as serverTaskID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return int|bool
     */
    public function getServerTaskID()
    {
        try {
            $this->setResult($this->getSoapClient()->getServerTaskID());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallerTypeID
     * Meta information extracted from the WSDL
     * - documentation: Gets as callerTypeID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getCallerTypeID()
    {
        try {
            $this->setResult($this->getSoapClient()->getCallerTypeID());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTimestamp
     * Meta information extracted from the WSDL
     * - documentation: Gets as timestamp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \DateTime|bool
     */
    public function getTimestamp()
    {
        try {
            $this->setResult($this->getSoapClient()->getTimestamp());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCountNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as countNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\CountNotificationType|bool
     */
    public function getCountNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getCountNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFillNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as fillNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\FillNotificationType|bool
     */
    public function getFillNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getFillNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDigitalInputNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as digitalInputNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\DigitalInputNotificationType|bool
     */
    public function getDigitalInputNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getDigitalInputNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCameraImagesNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as cameraImagesNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\CameraImagesNotificationType|bool
     */
    public function getCameraImagesNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getCameraImagesNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getParameterNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as parameterNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\ParameterNotificationType|bool
     */
    public function getParameterNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getParameterNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLogfilesNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as logfilesNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\LogfilesNotificationType|bool
     */
    public function getLogfilesNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getLogfilesNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getErrorLogfilesNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as errorLogfilesNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\ErrorLogfilesNotificationType|bool
     */
    public function getErrorLogfilesNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getErrorLogfilesNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAliveNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as aliveNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\AliveNotificationType|bool
     */
    public function getAliveNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getAliveNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCurrObjlistNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as currObjlistNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\CurrentObjectListNotificationType|bool
     */
    public function getCurrObjlistNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getCurrObjlistNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHistObjlistNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as histObjlistNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\HistoricObjectListNotificationType|bool
     */
    public function getHistObjlistNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getHistObjlistNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStartupNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as startupNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\StartupNotificationType|bool
     */
    public function getStartupNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getStartupNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClearZoneNotification
     * Meta information extracted from the WSDL
     * - documentation: Gets as clearZoneNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\ClearZoneNotificationType|bool
     */
    public function getClearZoneNotification()
    {
        try {
            $this->setResult($this->getSoapClient()->getClearZoneNotification());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOsdState
     * Meta information extracted from the WSDL
     * - documentation: Gets as osdState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getOsdState()
    {
        try {
            $this->setResult($this->getSoapClient()->getOsdState());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getId
     * Meta information extracted from the WSDL
     * - documentation: Gets as id
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return int|bool
     */
    public function getId()
    {
        try {
            $this->setResult($this->getSoapClient()->getId());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getZone
     * Meta information extracted from the WSDL
     * - documentation: Gets as zone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getZone()
    {
        try {
            $this->setResult($this->getSoapClient()->getZone());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDwell
     * Meta information extracted from the WSDL
     * - documentation: Gets as dwell
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getDwell()
    {
        try {
            $this->setResult($this->getSoapClient()->getDwell());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEntry
     * Meta information extracted from the WSDL
     * - documentation: Gets as entry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\Coordinate3DType|bool
     */
    public function getEntry()
    {
        try {
            $this->setResult($this->getSoapClient()->getEntry());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getParameterData
     * Meta information extracted from the WSDL
     * - documentation: Gets as parameterData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\BinaryDataType|bool
     */
    public function getParameterData()
    {
        try {
            $this->setResult($this->getSoapClient()->getParameterData());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRebootType
     * Meta information extracted from the WSDL
     * - documentation: Gets as rebootType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getRebootType()
    {
        try {
            $this->setResult($this->getSoapClient()->getRebootType());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDate
     * Meta information extracted from the WSDL
     * - documentation: Gets as date
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\DateType|bool
     */
    public function getDate()
    {
        try {
            $this->setResult($this->getSoapClient()->getDate());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStart
     * Meta information extracted from the WSDL
     * - documentation: Gets as start
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Counter\PushService\ClockTimeType|bool
     */
    public function getStart()
    {
        try {
            $this->setResult($this->getSoapClient()->getStart());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCycle
     * Meta information extracted from the WSDL
     * - documentation: Gets as cycle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \DateInterval|bool
     */
    public function getCycle()
    {
        try {
            $this->setResult($this->getSoapClient()->getCycle());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRandomOffset
     * Meta information extracted from the WSDL
     * - documentation: Gets as randomOffset
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \DateInterval|bool
     */
    public function getRandomOffset()
    {
        try {
            $this->setResult($this->getSoapClient()->getRandomOffset());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return bool|int|mixed|string|\Counter\PushService\AliveNotificationType|\Counter\PushService\BinaryDataType|\Counter\PushService\CameraImagesNotificationType|\Counter\PushService\ClearZoneIDType|\Counter\PushService\ClearZoneNotificationType|\Counter\PushService\ClockTimeType|\Counter\PushService\Coordinate2DType|\Counter\PushService\Coordinate3DType|\Counter\PushService\CountingGateIDType|\Counter\PushService\CountNotificationType|\Counter\PushService\CurrentObjectListNotificationType|\Counter\PushService\CurrentObjectType[]|\Counter\PushService\DateType|\Counter\PushService\DigitalInputElementType[]|\Counter\PushService\DigitalInputNotificationType|\Counter\PushService\ErrorLogfilesNotificationType|\Counter\PushService\FillNotificationType|\Counter\PushService\FillRegionIDType|\Counter\PushService\HistoricObjectListNotificationType|\Counter\PushService\LogfilesNotificationType|\Counter\PushService\ParameterNotificationType|\Counter\PushService\StartupNotificationType|\DateInterval|\DateTime
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
