<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeTriggerType StructType
 * Meta information extracted from the WSDL
 * - documentation: Class representing TimeTriggerType XSD Type: TimeTrigger
 * @subpackage Structs
 */
class TimeTriggerType extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\DateType
     */
    public $date;
    /**
     * The start
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\ClockTimeType
     */
    public $start;
    /**
     * The cycle
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $cycle;
    /**
     * The randomOffset
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $randomOffset;
    /**
     * Constructor method for TimeTriggerType
     * @uses TimeTriggerType::setDate()
     * @uses TimeTriggerType::setStart()
     * @uses TimeTriggerType::setCycle()
     * @uses TimeTriggerType::setRandomOffset()
     * @param \StructType\DateType $date
     * @param \StructType\ClockTimeType $start
     * @param string $cycle
     * @param string $randomOffset
     */
    public function __construct(\StructType\DateType $date = null, \StructType\ClockTimeType $start = null, $cycle = null, $randomOffset = null)
    {
        $this
            ->setDate($date)
            ->setStart($start)
            ->setCycle($cycle)
            ->setRandomOffset($randomOffset);
    }
    /**
     * Get date value
     * @return \StructType\DateType
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param \StructType\DateType $date
     * @return \StructType\TimeTriggerType
     */
    public function setDate(\StructType\DateType $date = null)
    {
        $this->date = $date;
        return $this;
    }
    /**
     * Get start value
     * @return \StructType\ClockTimeType
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param \StructType\ClockTimeType $start
     * @return \StructType\TimeTriggerType
     */
    public function setStart(\StructType\ClockTimeType $start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get cycle value
     * @return string
     */
    public function getCycle()
    {
        return $this->cycle;
    }
    /**
     * Set cycle value
     * @param string $cycle
     * @return \StructType\TimeTriggerType
     */
    public function setCycle($cycle = null)
    {
        // validation for constraint: string
        if (!is_null($cycle) && !is_string($cycle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cycle, true), gettype($cycle)), __LINE__);
        }
        $this->cycle = $cycle;
        return $this;
    }
    /**
     * Get randomOffset value
     * @return string
     */
    public function getRandomOffset()
    {
        return $this->randomOffset;
    }
    /**
     * Set randomOffset value
     * @param string $randomOffset
     * @return \StructType\TimeTriggerType
     */
    public function setRandomOffset($randomOffset = null)
    {
        // validation for constraint: string
        if (!is_null($randomOffset) && !is_string($randomOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($randomOffset, true), gettype($randomOffset)), __LINE__);
        }
        $this->randomOffset = $randomOffset;
        return $this;
    }
}
