<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskContainerType StructType
 * Meta information extracted from the WSDL
 * - documentation: Class representing TaskContainerType
 * @subpackage Structs
 */
class TaskContainerType extends AbstractStructBase
{
    /**
     * The taskRequestUpdate
     * Meta information extracted from the WSDL
     * - documentation: definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskRequestUpdateType[]
     */
    public $taskRequestUpdate;
    /**
     * The taskRequestParameters
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskRequestParametersType[]
     */
    public $taskRequestParameters;
    /**
     * The taskSubscribeLogfiles
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSubscribeLogfilesType[]
     */
    public $taskSubscribeLogfiles;
    /**
     * The taskSubscribeErrorLog
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSubscribeErrorLogType[]
     */
    public $taskSubscribeErrorLog;
    /**
     * The taskSetDigitalOutput
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSetDigitalOutputType[]
     */
    public $taskSetDigitalOutput;
    /**
     * The taskSetDateTime
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSetDateTimeType[]
     */
    public $taskSetDateTime;
    /**
     * The taskSubscribeCounting
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSubscribeCountingType[]
     */
    public $taskSubscribeCounting;
    /**
     * The taskSubscribeFill
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSubscribeFillType[]
     */
    public $taskSubscribeFill;
    /**
     * The taskSubscribeDigitalInput
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSubscribeDigitalInputType[]
     */
    public $taskSubscribeDigitalInput;
    /**
     * The taskSubscribeCameraImages
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSubscribeCameraImagesType[]
     */
    public $taskSubscribeCameraImages;
    /**
     * The taskSubscribeSendParameters
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSubscribeSendParametersType[]
     */
    public $taskSubscribeSendParameters;
    /**
     * The taskSubscribeVideoStore
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSubscribeVideoStoreType[]
     */
    public $taskSubscribeVideoStore;
    /**
     * The taskSubscribeAlive
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSubscribeAliveType[]
     */
    public $taskSubscribeAlive;
    /**
     * The taskSubscribeObjlist
     * Meta information extracted from the WSDL
     * - documentation: definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSubscribeObjectListType[]
     */
    public $taskSubscribeObjlist;
    /**
     * The taskRebootNow
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskRebootNowType[]
     */
    public $taskRebootNow;
    /**
     * The taskSubscribeClearZone
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TaskSubscribeClearZoneType[]
     */
    public $taskSubscribeClearZone;
    /**
     * Constructor method for TaskContainerType
     * @uses TaskContainerType::setTaskRequestUpdate()
     * @uses TaskContainerType::setTaskRequestParameters()
     * @uses TaskContainerType::setTaskSubscribeLogfiles()
     * @uses TaskContainerType::setTaskSubscribeErrorLog()
     * @uses TaskContainerType::setTaskSetDigitalOutput()
     * @uses TaskContainerType::setTaskSetDateTime()
     * @uses TaskContainerType::setTaskSubscribeCounting()
     * @uses TaskContainerType::setTaskSubscribeFill()
     * @uses TaskContainerType::setTaskSubscribeDigitalInput()
     * @uses TaskContainerType::setTaskSubscribeCameraImages()
     * @uses TaskContainerType::setTaskSubscribeSendParameters()
     * @uses TaskContainerType::setTaskSubscribeVideoStore()
     * @uses TaskContainerType::setTaskSubscribeAlive()
     * @uses TaskContainerType::setTaskSubscribeObjlist()
     * @uses TaskContainerType::setTaskRebootNow()
     * @uses TaskContainerType::setTaskSubscribeClearZone()
     * @param \StructType\TaskRequestUpdateType[] $taskRequestUpdate
     * @param \StructType\TaskRequestParametersType[] $taskRequestParameters
     * @param \StructType\TaskSubscribeLogfilesType[] $taskSubscribeLogfiles
     * @param \StructType\TaskSubscribeErrorLogType[] $taskSubscribeErrorLog
     * @param \StructType\TaskSetDigitalOutputType[] $taskSetDigitalOutput
     * @param \StructType\TaskSetDateTimeType[] $taskSetDateTime
     * @param \StructType\TaskSubscribeCountingType[] $taskSubscribeCounting
     * @param \StructType\TaskSubscribeFillType[] $taskSubscribeFill
     * @param \StructType\TaskSubscribeDigitalInputType[] $taskSubscribeDigitalInput
     * @param \StructType\TaskSubscribeCameraImagesType[] $taskSubscribeCameraImages
     * @param \StructType\TaskSubscribeSendParametersType[] $taskSubscribeSendParameters
     * @param \StructType\TaskSubscribeVideoStoreType[] $taskSubscribeVideoStore
     * @param \StructType\TaskSubscribeAliveType[] $taskSubscribeAlive
     * @param \StructType\TaskSubscribeObjectListType[] $taskSubscribeObjlist
     * @param \StructType\TaskRebootNowType[] $taskRebootNow
     * @param \StructType\TaskSubscribeClearZoneType[] $taskSubscribeClearZone
     */
    public function __construct(array $taskRequestUpdate = array(), array $taskRequestParameters = array(), array $taskSubscribeLogfiles = array(), array $taskSubscribeErrorLog = array(), array $taskSetDigitalOutput = array(), array $taskSetDateTime = array(), array $taskSubscribeCounting = array(), array $taskSubscribeFill = array(), array $taskSubscribeDigitalInput = array(), array $taskSubscribeCameraImages = array(), array $taskSubscribeSendParameters = array(), array $taskSubscribeVideoStore = array(), array $taskSubscribeAlive = array(), array $taskSubscribeObjlist = array(), array $taskRebootNow = array(), array $taskSubscribeClearZone = array())
    {
        $this
            ->setTaskRequestUpdate($taskRequestUpdate)
            ->setTaskRequestParameters($taskRequestParameters)
            ->setTaskSubscribeLogfiles($taskSubscribeLogfiles)
            ->setTaskSubscribeErrorLog($taskSubscribeErrorLog)
            ->setTaskSetDigitalOutput($taskSetDigitalOutput)
            ->setTaskSetDateTime($taskSetDateTime)
            ->setTaskSubscribeCounting($taskSubscribeCounting)
            ->setTaskSubscribeFill($taskSubscribeFill)
            ->setTaskSubscribeDigitalInput($taskSubscribeDigitalInput)
            ->setTaskSubscribeCameraImages($taskSubscribeCameraImages)
            ->setTaskSubscribeSendParameters($taskSubscribeSendParameters)
            ->setTaskSubscribeVideoStore($taskSubscribeVideoStore)
            ->setTaskSubscribeAlive($taskSubscribeAlive)
            ->setTaskSubscribeObjlist($taskSubscribeObjlist)
            ->setTaskRebootNow($taskRebootNow)
            ->setTaskSubscribeClearZone($taskSubscribeClearZone);
    }
    /**
     * Get taskRequestUpdate value
     * @return \StructType\TaskRequestUpdateType[]
     */
    public function getTaskRequestUpdate()
    {
        return $this->taskRequestUpdate;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskRequestUpdate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskRequestUpdate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskRequestUpdateForArrayConstraintsFromSetTaskRequestUpdate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskRequestUpdateItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskRequestUpdateItem instanceof \StructType\TaskRequestUpdateType) {
                $invalidValues[] = is_object($taskContainerTypeTaskRequestUpdateItem) ? get_class($taskContainerTypeTaskRequestUpdateItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskRequestUpdateItem), var_export($taskContainerTypeTaskRequestUpdateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskRequestUpdate property can only contain items of type \StructType\TaskRequestUpdateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskRequestUpdate value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskRequestUpdateType[] $taskRequestUpdate
     * @return \StructType\TaskContainerType
     */
    public function setTaskRequestUpdate(array $taskRequestUpdate = array())
    {
        // validation for constraint: array
        if ('' !== ($taskRequestUpdateArrayErrorMessage = self::validateTaskRequestUpdateForArrayConstraintsFromSetTaskRequestUpdate($taskRequestUpdate))) {
            throw new \InvalidArgumentException($taskRequestUpdateArrayErrorMessage, __LINE__);
        }
        $this->taskRequestUpdate = $taskRequestUpdate;
        return $this;
    }
    /**
     * Add item to taskRequestUpdate value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskRequestUpdateType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskRequestUpdate(\StructType\TaskRequestUpdateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskRequestUpdateType) {
            throw new \InvalidArgumentException(sprintf('The taskRequestUpdate property can only contain items of type \StructType\TaskRequestUpdateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskRequestUpdate[] = $item;
        return $this;
    }
    /**
     * Get taskRequestParameters value
     * @return \StructType\TaskRequestParametersType[]
     */
    public function getTaskRequestParameters()
    {
        return $this->taskRequestParameters;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskRequestParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskRequestParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskRequestParametersForArrayConstraintsFromSetTaskRequestParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskRequestParametersItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskRequestParametersItem instanceof \StructType\TaskRequestParametersType) {
                $invalidValues[] = is_object($taskContainerTypeTaskRequestParametersItem) ? get_class($taskContainerTypeTaskRequestParametersItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskRequestParametersItem), var_export($taskContainerTypeTaskRequestParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskRequestParameters property can only contain items of type \StructType\TaskRequestParametersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskRequestParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskRequestParametersType[] $taskRequestParameters
     * @return \StructType\TaskContainerType
     */
    public function setTaskRequestParameters(array $taskRequestParameters = array())
    {
        // validation for constraint: array
        if ('' !== ($taskRequestParametersArrayErrorMessage = self::validateTaskRequestParametersForArrayConstraintsFromSetTaskRequestParameters($taskRequestParameters))) {
            throw new \InvalidArgumentException($taskRequestParametersArrayErrorMessage, __LINE__);
        }
        $this->taskRequestParameters = $taskRequestParameters;
        return $this;
    }
    /**
     * Add item to taskRequestParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskRequestParametersType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskRequestParameters(\StructType\TaskRequestParametersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskRequestParametersType) {
            throw new \InvalidArgumentException(sprintf('The taskRequestParameters property can only contain items of type \StructType\TaskRequestParametersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskRequestParameters[] = $item;
        return $this;
    }
    /**
     * Get taskSubscribeLogfiles value
     * @return \StructType\TaskSubscribeLogfilesType[]
     */
    public function getTaskSubscribeLogfiles()
    {
        return $this->taskSubscribeLogfiles;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSubscribeLogfiles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSubscribeLogfiles method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSubscribeLogfilesForArrayConstraintsFromSetTaskSubscribeLogfiles(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSubscribeLogfilesItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSubscribeLogfilesItem instanceof \StructType\TaskSubscribeLogfilesType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSubscribeLogfilesItem) ? get_class($taskContainerTypeTaskSubscribeLogfilesItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSubscribeLogfilesItem), var_export($taskContainerTypeTaskSubscribeLogfilesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSubscribeLogfiles property can only contain items of type \StructType\TaskSubscribeLogfilesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSubscribeLogfiles value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeLogfilesType[] $taskSubscribeLogfiles
     * @return \StructType\TaskContainerType
     */
    public function setTaskSubscribeLogfiles(array $taskSubscribeLogfiles = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSubscribeLogfilesArrayErrorMessage = self::validateTaskSubscribeLogfilesForArrayConstraintsFromSetTaskSubscribeLogfiles($taskSubscribeLogfiles))) {
            throw new \InvalidArgumentException($taskSubscribeLogfilesArrayErrorMessage, __LINE__);
        }
        $this->taskSubscribeLogfiles = $taskSubscribeLogfiles;
        return $this;
    }
    /**
     * Add item to taskSubscribeLogfiles value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeLogfilesType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSubscribeLogfiles(\StructType\TaskSubscribeLogfilesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSubscribeLogfilesType) {
            throw new \InvalidArgumentException(sprintf('The taskSubscribeLogfiles property can only contain items of type \StructType\TaskSubscribeLogfilesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSubscribeLogfiles[] = $item;
        return $this;
    }
    /**
     * Get taskSubscribeErrorLog value
     * @return \StructType\TaskSubscribeErrorLogType[]
     */
    public function getTaskSubscribeErrorLog()
    {
        return $this->taskSubscribeErrorLog;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSubscribeErrorLog method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSubscribeErrorLog method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSubscribeErrorLogForArrayConstraintsFromSetTaskSubscribeErrorLog(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSubscribeErrorLogItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSubscribeErrorLogItem instanceof \StructType\TaskSubscribeErrorLogType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSubscribeErrorLogItem) ? get_class($taskContainerTypeTaskSubscribeErrorLogItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSubscribeErrorLogItem), var_export($taskContainerTypeTaskSubscribeErrorLogItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSubscribeErrorLog property can only contain items of type \StructType\TaskSubscribeErrorLogType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSubscribeErrorLog value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeErrorLogType[] $taskSubscribeErrorLog
     * @return \StructType\TaskContainerType
     */
    public function setTaskSubscribeErrorLog(array $taskSubscribeErrorLog = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSubscribeErrorLogArrayErrorMessage = self::validateTaskSubscribeErrorLogForArrayConstraintsFromSetTaskSubscribeErrorLog($taskSubscribeErrorLog))) {
            throw new \InvalidArgumentException($taskSubscribeErrorLogArrayErrorMessage, __LINE__);
        }
        $this->taskSubscribeErrorLog = $taskSubscribeErrorLog;
        return $this;
    }
    /**
     * Add item to taskSubscribeErrorLog value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeErrorLogType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSubscribeErrorLog(\StructType\TaskSubscribeErrorLogType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSubscribeErrorLogType) {
            throw new \InvalidArgumentException(sprintf('The taskSubscribeErrorLog property can only contain items of type \StructType\TaskSubscribeErrorLogType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSubscribeErrorLog[] = $item;
        return $this;
    }
    /**
     * Get taskSetDigitalOutput value
     * @return \StructType\TaskSetDigitalOutputType[]
     */
    public function getTaskSetDigitalOutput()
    {
        return $this->taskSetDigitalOutput;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSetDigitalOutput method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSetDigitalOutput method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSetDigitalOutputForArrayConstraintsFromSetTaskSetDigitalOutput(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSetDigitalOutputItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSetDigitalOutputItem instanceof \StructType\TaskSetDigitalOutputType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSetDigitalOutputItem) ? get_class($taskContainerTypeTaskSetDigitalOutputItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSetDigitalOutputItem), var_export($taskContainerTypeTaskSetDigitalOutputItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSetDigitalOutput property can only contain items of type \StructType\TaskSetDigitalOutputType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSetDigitalOutput value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSetDigitalOutputType[] $taskSetDigitalOutput
     * @return \StructType\TaskContainerType
     */
    public function setTaskSetDigitalOutput(array $taskSetDigitalOutput = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSetDigitalOutputArrayErrorMessage = self::validateTaskSetDigitalOutputForArrayConstraintsFromSetTaskSetDigitalOutput($taskSetDigitalOutput))) {
            throw new \InvalidArgumentException($taskSetDigitalOutputArrayErrorMessage, __LINE__);
        }
        $this->taskSetDigitalOutput = $taskSetDigitalOutput;
        return $this;
    }
    /**
     * Add item to taskSetDigitalOutput value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSetDigitalOutputType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSetDigitalOutput(\StructType\TaskSetDigitalOutputType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSetDigitalOutputType) {
            throw new \InvalidArgumentException(sprintf('The taskSetDigitalOutput property can only contain items of type \StructType\TaskSetDigitalOutputType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSetDigitalOutput[] = $item;
        return $this;
    }
    /**
     * Get taskSetDateTime value
     * @return \StructType\TaskSetDateTimeType[]
     */
    public function getTaskSetDateTime()
    {
        return $this->taskSetDateTime;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSetDateTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSetDateTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSetDateTimeForArrayConstraintsFromSetTaskSetDateTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSetDateTimeItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSetDateTimeItem instanceof \StructType\TaskSetDateTimeType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSetDateTimeItem) ? get_class($taskContainerTypeTaskSetDateTimeItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSetDateTimeItem), var_export($taskContainerTypeTaskSetDateTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSetDateTime property can only contain items of type \StructType\TaskSetDateTimeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSetDateTime value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSetDateTimeType[] $taskSetDateTime
     * @return \StructType\TaskContainerType
     */
    public function setTaskSetDateTime(array $taskSetDateTime = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSetDateTimeArrayErrorMessage = self::validateTaskSetDateTimeForArrayConstraintsFromSetTaskSetDateTime($taskSetDateTime))) {
            throw new \InvalidArgumentException($taskSetDateTimeArrayErrorMessage, __LINE__);
        }
        $this->taskSetDateTime = $taskSetDateTime;
        return $this;
    }
    /**
     * Add item to taskSetDateTime value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSetDateTimeType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSetDateTime(\StructType\TaskSetDateTimeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSetDateTimeType) {
            throw new \InvalidArgumentException(sprintf('The taskSetDateTime property can only contain items of type \StructType\TaskSetDateTimeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSetDateTime[] = $item;
        return $this;
    }
    /**
     * Get taskSubscribeCounting value
     * @return \StructType\TaskSubscribeCountingType[]
     */
    public function getTaskSubscribeCounting()
    {
        return $this->taskSubscribeCounting;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSubscribeCounting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSubscribeCounting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSubscribeCountingForArrayConstraintsFromSetTaskSubscribeCounting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSubscribeCountingItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSubscribeCountingItem instanceof \StructType\TaskSubscribeCountingType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSubscribeCountingItem) ? get_class($taskContainerTypeTaskSubscribeCountingItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSubscribeCountingItem), var_export($taskContainerTypeTaskSubscribeCountingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSubscribeCounting property can only contain items of type \StructType\TaskSubscribeCountingType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSubscribeCounting value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeCountingType[] $taskSubscribeCounting
     * @return \StructType\TaskContainerType
     */
    public function setTaskSubscribeCounting(array $taskSubscribeCounting = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSubscribeCountingArrayErrorMessage = self::validateTaskSubscribeCountingForArrayConstraintsFromSetTaskSubscribeCounting($taskSubscribeCounting))) {
            throw new \InvalidArgumentException($taskSubscribeCountingArrayErrorMessage, __LINE__);
        }
        $this->taskSubscribeCounting = $taskSubscribeCounting;
        return $this;
    }
    /**
     * Add item to taskSubscribeCounting value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeCountingType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSubscribeCounting(\StructType\TaskSubscribeCountingType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSubscribeCountingType) {
            throw new \InvalidArgumentException(sprintf('The taskSubscribeCounting property can only contain items of type \StructType\TaskSubscribeCountingType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSubscribeCounting[] = $item;
        return $this;
    }
    /**
     * Get taskSubscribeFill value
     * @return \StructType\TaskSubscribeFillType[]
     */
    public function getTaskSubscribeFill()
    {
        return $this->taskSubscribeFill;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSubscribeFill method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSubscribeFill method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSubscribeFillForArrayConstraintsFromSetTaskSubscribeFill(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSubscribeFillItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSubscribeFillItem instanceof \StructType\TaskSubscribeFillType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSubscribeFillItem) ? get_class($taskContainerTypeTaskSubscribeFillItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSubscribeFillItem), var_export($taskContainerTypeTaskSubscribeFillItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSubscribeFill property can only contain items of type \StructType\TaskSubscribeFillType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSubscribeFill value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeFillType[] $taskSubscribeFill
     * @return \StructType\TaskContainerType
     */
    public function setTaskSubscribeFill(array $taskSubscribeFill = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSubscribeFillArrayErrorMessage = self::validateTaskSubscribeFillForArrayConstraintsFromSetTaskSubscribeFill($taskSubscribeFill))) {
            throw new \InvalidArgumentException($taskSubscribeFillArrayErrorMessage, __LINE__);
        }
        $this->taskSubscribeFill = $taskSubscribeFill;
        return $this;
    }
    /**
     * Add item to taskSubscribeFill value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeFillType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSubscribeFill(\StructType\TaskSubscribeFillType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSubscribeFillType) {
            throw new \InvalidArgumentException(sprintf('The taskSubscribeFill property can only contain items of type \StructType\TaskSubscribeFillType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSubscribeFill[] = $item;
        return $this;
    }
    /**
     * Get taskSubscribeDigitalInput value
     * @return \StructType\TaskSubscribeDigitalInputType[]
     */
    public function getTaskSubscribeDigitalInput()
    {
        return $this->taskSubscribeDigitalInput;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSubscribeDigitalInput method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSubscribeDigitalInput method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSubscribeDigitalInputForArrayConstraintsFromSetTaskSubscribeDigitalInput(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSubscribeDigitalInputItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSubscribeDigitalInputItem instanceof \StructType\TaskSubscribeDigitalInputType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSubscribeDigitalInputItem) ? get_class($taskContainerTypeTaskSubscribeDigitalInputItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSubscribeDigitalInputItem), var_export($taskContainerTypeTaskSubscribeDigitalInputItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSubscribeDigitalInput property can only contain items of type \StructType\TaskSubscribeDigitalInputType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSubscribeDigitalInput value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeDigitalInputType[] $taskSubscribeDigitalInput
     * @return \StructType\TaskContainerType
     */
    public function setTaskSubscribeDigitalInput(array $taskSubscribeDigitalInput = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSubscribeDigitalInputArrayErrorMessage = self::validateTaskSubscribeDigitalInputForArrayConstraintsFromSetTaskSubscribeDigitalInput($taskSubscribeDigitalInput))) {
            throw new \InvalidArgumentException($taskSubscribeDigitalInputArrayErrorMessage, __LINE__);
        }
        $this->taskSubscribeDigitalInput = $taskSubscribeDigitalInput;
        return $this;
    }
    /**
     * Add item to taskSubscribeDigitalInput value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeDigitalInputType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSubscribeDigitalInput(\StructType\TaskSubscribeDigitalInputType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSubscribeDigitalInputType) {
            throw new \InvalidArgumentException(sprintf('The taskSubscribeDigitalInput property can only contain items of type \StructType\TaskSubscribeDigitalInputType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSubscribeDigitalInput[] = $item;
        return $this;
    }
    /**
     * Get taskSubscribeCameraImages value
     * @return \StructType\TaskSubscribeCameraImagesType[]
     */
    public function getTaskSubscribeCameraImages()
    {
        return $this->taskSubscribeCameraImages;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSubscribeCameraImages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSubscribeCameraImages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSubscribeCameraImagesForArrayConstraintsFromSetTaskSubscribeCameraImages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSubscribeCameraImagesItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSubscribeCameraImagesItem instanceof \StructType\TaskSubscribeCameraImagesType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSubscribeCameraImagesItem) ? get_class($taskContainerTypeTaskSubscribeCameraImagesItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSubscribeCameraImagesItem), var_export($taskContainerTypeTaskSubscribeCameraImagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSubscribeCameraImages property can only contain items of type \StructType\TaskSubscribeCameraImagesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSubscribeCameraImages value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeCameraImagesType[] $taskSubscribeCameraImages
     * @return \StructType\TaskContainerType
     */
    public function setTaskSubscribeCameraImages(array $taskSubscribeCameraImages = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSubscribeCameraImagesArrayErrorMessage = self::validateTaskSubscribeCameraImagesForArrayConstraintsFromSetTaskSubscribeCameraImages($taskSubscribeCameraImages))) {
            throw new \InvalidArgumentException($taskSubscribeCameraImagesArrayErrorMessage, __LINE__);
        }
        $this->taskSubscribeCameraImages = $taskSubscribeCameraImages;
        return $this;
    }
    /**
     * Add item to taskSubscribeCameraImages value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeCameraImagesType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSubscribeCameraImages(\StructType\TaskSubscribeCameraImagesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSubscribeCameraImagesType) {
            throw new \InvalidArgumentException(sprintf('The taskSubscribeCameraImages property can only contain items of type \StructType\TaskSubscribeCameraImagesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSubscribeCameraImages[] = $item;
        return $this;
    }
    /**
     * Get taskSubscribeSendParameters value
     * @return \StructType\TaskSubscribeSendParametersType[]
     */
    public function getTaskSubscribeSendParameters()
    {
        return $this->taskSubscribeSendParameters;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSubscribeSendParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSubscribeSendParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSubscribeSendParametersForArrayConstraintsFromSetTaskSubscribeSendParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSubscribeSendParametersItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSubscribeSendParametersItem instanceof \StructType\TaskSubscribeSendParametersType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSubscribeSendParametersItem) ? get_class($taskContainerTypeTaskSubscribeSendParametersItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSubscribeSendParametersItem), var_export($taskContainerTypeTaskSubscribeSendParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSubscribeSendParameters property can only contain items of type \StructType\TaskSubscribeSendParametersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSubscribeSendParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeSendParametersType[] $taskSubscribeSendParameters
     * @return \StructType\TaskContainerType
     */
    public function setTaskSubscribeSendParameters(array $taskSubscribeSendParameters = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSubscribeSendParametersArrayErrorMessage = self::validateTaskSubscribeSendParametersForArrayConstraintsFromSetTaskSubscribeSendParameters($taskSubscribeSendParameters))) {
            throw new \InvalidArgumentException($taskSubscribeSendParametersArrayErrorMessage, __LINE__);
        }
        $this->taskSubscribeSendParameters = $taskSubscribeSendParameters;
        return $this;
    }
    /**
     * Add item to taskSubscribeSendParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeSendParametersType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSubscribeSendParameters(\StructType\TaskSubscribeSendParametersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSubscribeSendParametersType) {
            throw new \InvalidArgumentException(sprintf('The taskSubscribeSendParameters property can only contain items of type \StructType\TaskSubscribeSendParametersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSubscribeSendParameters[] = $item;
        return $this;
    }
    /**
     * Get taskSubscribeVideoStore value
     * @return \StructType\TaskSubscribeVideoStoreType[]
     */
    public function getTaskSubscribeVideoStore()
    {
        return $this->taskSubscribeVideoStore;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSubscribeVideoStore method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSubscribeVideoStore method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSubscribeVideoStoreForArrayConstraintsFromSetTaskSubscribeVideoStore(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSubscribeVideoStoreItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSubscribeVideoStoreItem instanceof \StructType\TaskSubscribeVideoStoreType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSubscribeVideoStoreItem) ? get_class($taskContainerTypeTaskSubscribeVideoStoreItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSubscribeVideoStoreItem), var_export($taskContainerTypeTaskSubscribeVideoStoreItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSubscribeVideoStore property can only contain items of type \StructType\TaskSubscribeVideoStoreType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSubscribeVideoStore value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeVideoStoreType[] $taskSubscribeVideoStore
     * @return \StructType\TaskContainerType
     */
    public function setTaskSubscribeVideoStore(array $taskSubscribeVideoStore = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSubscribeVideoStoreArrayErrorMessage = self::validateTaskSubscribeVideoStoreForArrayConstraintsFromSetTaskSubscribeVideoStore($taskSubscribeVideoStore))) {
            throw new \InvalidArgumentException($taskSubscribeVideoStoreArrayErrorMessage, __LINE__);
        }
        $this->taskSubscribeVideoStore = $taskSubscribeVideoStore;
        return $this;
    }
    /**
     * Add item to taskSubscribeVideoStore value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeVideoStoreType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSubscribeVideoStore(\StructType\TaskSubscribeVideoStoreType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSubscribeVideoStoreType) {
            throw new \InvalidArgumentException(sprintf('The taskSubscribeVideoStore property can only contain items of type \StructType\TaskSubscribeVideoStoreType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSubscribeVideoStore[] = $item;
        return $this;
    }
    /**
     * Get taskSubscribeAlive value
     * @return \StructType\TaskSubscribeAliveType[]
     */
    public function getTaskSubscribeAlive()
    {
        return $this->taskSubscribeAlive;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSubscribeAlive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSubscribeAlive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSubscribeAliveForArrayConstraintsFromSetTaskSubscribeAlive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSubscribeAliveItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSubscribeAliveItem instanceof \StructType\TaskSubscribeAliveType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSubscribeAliveItem) ? get_class($taskContainerTypeTaskSubscribeAliveItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSubscribeAliveItem), var_export($taskContainerTypeTaskSubscribeAliveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSubscribeAlive property can only contain items of type \StructType\TaskSubscribeAliveType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSubscribeAlive value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeAliveType[] $taskSubscribeAlive
     * @return \StructType\TaskContainerType
     */
    public function setTaskSubscribeAlive(array $taskSubscribeAlive = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSubscribeAliveArrayErrorMessage = self::validateTaskSubscribeAliveForArrayConstraintsFromSetTaskSubscribeAlive($taskSubscribeAlive))) {
            throw new \InvalidArgumentException($taskSubscribeAliveArrayErrorMessage, __LINE__);
        }
        $this->taskSubscribeAlive = $taskSubscribeAlive;
        return $this;
    }
    /**
     * Add item to taskSubscribeAlive value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeAliveType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSubscribeAlive(\StructType\TaskSubscribeAliveType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSubscribeAliveType) {
            throw new \InvalidArgumentException(sprintf('The taskSubscribeAlive property can only contain items of type \StructType\TaskSubscribeAliveType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSubscribeAlive[] = $item;
        return $this;
    }
    /**
     * Get taskSubscribeObjlist value
     * @return \StructType\TaskSubscribeObjectListType[]
     */
    public function getTaskSubscribeObjlist()
    {
        return $this->taskSubscribeObjlist;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSubscribeObjlist method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSubscribeObjlist method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSubscribeObjlistForArrayConstraintsFromSetTaskSubscribeObjlist(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSubscribeObjlistItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSubscribeObjlistItem instanceof \StructType\TaskSubscribeObjectListType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSubscribeObjlistItem) ? get_class($taskContainerTypeTaskSubscribeObjlistItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSubscribeObjlistItem), var_export($taskContainerTypeTaskSubscribeObjlistItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSubscribeObjlist property can only contain items of type \StructType\TaskSubscribeObjectListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSubscribeObjlist value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeObjectListType[] $taskSubscribeObjlist
     * @return \StructType\TaskContainerType
     */
    public function setTaskSubscribeObjlist(array $taskSubscribeObjlist = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSubscribeObjlistArrayErrorMessage = self::validateTaskSubscribeObjlistForArrayConstraintsFromSetTaskSubscribeObjlist($taskSubscribeObjlist))) {
            throw new \InvalidArgumentException($taskSubscribeObjlistArrayErrorMessage, __LINE__);
        }
        $this->taskSubscribeObjlist = $taskSubscribeObjlist;
        return $this;
    }
    /**
     * Add item to taskSubscribeObjlist value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeObjectListType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSubscribeObjlist(\StructType\TaskSubscribeObjectListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSubscribeObjectListType) {
            throw new \InvalidArgumentException(sprintf('The taskSubscribeObjlist property can only contain items of type \StructType\TaskSubscribeObjectListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSubscribeObjlist[] = $item;
        return $this;
    }
    /**
     * Get taskRebootNow value
     * @return \StructType\TaskRebootNowType[]
     */
    public function getTaskRebootNow()
    {
        return $this->taskRebootNow;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskRebootNow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskRebootNow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskRebootNowForArrayConstraintsFromSetTaskRebootNow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskRebootNowItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskRebootNowItem instanceof \StructType\TaskRebootNowType) {
                $invalidValues[] = is_object($taskContainerTypeTaskRebootNowItem) ? get_class($taskContainerTypeTaskRebootNowItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskRebootNowItem), var_export($taskContainerTypeTaskRebootNowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskRebootNow property can only contain items of type \StructType\TaskRebootNowType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskRebootNow value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskRebootNowType[] $taskRebootNow
     * @return \StructType\TaskContainerType
     */
    public function setTaskRebootNow(array $taskRebootNow = array())
    {
        // validation for constraint: array
        if ('' !== ($taskRebootNowArrayErrorMessage = self::validateTaskRebootNowForArrayConstraintsFromSetTaskRebootNow($taskRebootNow))) {
            throw new \InvalidArgumentException($taskRebootNowArrayErrorMessage, __LINE__);
        }
        $this->taskRebootNow = $taskRebootNow;
        return $this;
    }
    /**
     * Add item to taskRebootNow value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskRebootNowType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskRebootNow(\StructType\TaskRebootNowType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskRebootNowType) {
            throw new \InvalidArgumentException(sprintf('The taskRebootNow property can only contain items of type \StructType\TaskRebootNowType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskRebootNow[] = $item;
        return $this;
    }
    /**
     * Get taskSubscribeClearZone value
     * @return \StructType\TaskSubscribeClearZoneType[]
     */
    public function getTaskSubscribeClearZone()
    {
        return $this->taskSubscribeClearZone;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskSubscribeClearZone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskSubscribeClearZone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskSubscribeClearZoneForArrayConstraintsFromSetTaskSubscribeClearZone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskContainerTypeTaskSubscribeClearZoneItem) {
            // validation for constraint: itemType
            if (!$taskContainerTypeTaskSubscribeClearZoneItem instanceof \StructType\TaskSubscribeClearZoneType) {
                $invalidValues[] = is_object($taskContainerTypeTaskSubscribeClearZoneItem) ? get_class($taskContainerTypeTaskSubscribeClearZoneItem) : sprintf('%s(%s)', gettype($taskContainerTypeTaskSubscribeClearZoneItem), var_export($taskContainerTypeTaskSubscribeClearZoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskSubscribeClearZone property can only contain items of type \StructType\TaskSubscribeClearZoneType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskSubscribeClearZone value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeClearZoneType[] $taskSubscribeClearZone
     * @return \StructType\TaskContainerType
     */
    public function setTaskSubscribeClearZone(array $taskSubscribeClearZone = array())
    {
        // validation for constraint: array
        if ('' !== ($taskSubscribeClearZoneArrayErrorMessage = self::validateTaskSubscribeClearZoneForArrayConstraintsFromSetTaskSubscribeClearZone($taskSubscribeClearZone))) {
            throw new \InvalidArgumentException($taskSubscribeClearZoneArrayErrorMessage, __LINE__);
        }
        $this->taskSubscribeClearZone = $taskSubscribeClearZone;
        return $this;
    }
    /**
     * Add item to taskSubscribeClearZone value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskSubscribeClearZoneType $item
     * @return \StructType\TaskContainerType
     */
    public function addToTaskSubscribeClearZone(\StructType\TaskSubscribeClearZoneType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskSubscribeClearZoneType) {
            throw new \InvalidArgumentException(sprintf('The taskSubscribeClearZone property can only contain items of type \StructType\TaskSubscribeClearZoneType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskSubscribeClearZone[] = $item;
        return $this;
    }
}
