<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Class representing DateType XSD Type: Date
 * @subpackage Structs
 */
class DateType extends AbstractStructBase
{
    /**
     * The kind
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $kind;
    /**
     * The dayOfWeek
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $dayOfWeek;
    /**
     * The dayOfMonth
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $dayOfMonth;
    /**
     * Constructor method for DateType
     * @uses DateType::setKind()
     * @uses DateType::setDayOfWeek()
     * @uses DateType::setDayOfMonth()
     * @param string $kind
     * @param string $dayOfWeek
     * @param string $dayOfMonth
     */
    public function __construct($kind = null, $dayOfWeek = null, $dayOfMonth = null)
    {
        $this
            ->setKind($kind)
            ->setDayOfWeek($dayOfWeek)
            ->setDayOfMonth($dayOfMonth);
    }
    /**
     * Get kind value
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * Set kind value
     * @param string $kind
     * @return \StructType\DateType
     */
    public function setKind($kind = null)
    {
        // validation for constraint: string
        if (!is_null($kind) && !is_string($kind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kind, true), gettype($kind)), __LINE__);
        }
        $this->kind = $kind;
        return $this;
    }
    /**
     * Get dayOfWeek value
     * @return string
     */
    public function getDayOfWeek()
    {
        return $this->dayOfWeek;
    }
    /**
     * Set dayOfWeek value
     * @param string $dayOfWeek
     * @return \StructType\DateType
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($dayOfWeek) && !is_string($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dayOfWeek, true), gettype($dayOfWeek)), __LINE__);
        }
        $this->dayOfWeek = $dayOfWeek;
        return $this;
    }
    /**
     * Get dayOfMonth value
     * @return string
     */
    public function getDayOfMonth()
    {
        return $this->dayOfMonth;
    }
    /**
     * Set dayOfMonth value
     * @param string $dayOfMonth
     * @return \StructType\DateType
     */
    public function setDayOfMonth($dayOfMonth = null)
    {
        // validation for constraint: string
        if (!is_null($dayOfMonth) && !is_string($dayOfMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dayOfMonth, true), gettype($dayOfMonth)), __LINE__);
        }
        $this->dayOfMonth = $dayOfMonth;
        return $this;
    }
}
