<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClockTimeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Class representing ClockTimeType XSD Type: ClockTime
 * @subpackage Structs
 */
class ClockTimeType extends AbstractStructBase
{
    /**
     * The hours
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $hours;
    /**
     * The minutes
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $minutes;
    /**
     * The seconds
     * Meta information extracted from the WSDL
     * - documentation: Definicion de este elemento
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $seconds;
    /**
     * Constructor method for ClockTimeType
     * @uses ClockTimeType::setHours()
     * @uses ClockTimeType::setMinutes()
     * @uses ClockTimeType::setSeconds()
     * @param int $hours
     * @param int $minutes
     * @param int $seconds
     */
    public function __construct($hours = null, $minutes = null, $seconds = null)
    {
        $this
            ->setHours($hours)
            ->setMinutes($minutes)
            ->setSeconds($seconds);
    }
    /**
     * Get hours value
     * @return int
     */
    public function getHours()
    {
        return $this->hours;
    }
    /**
     * Set hours value
     * @param int $hours
     * @return \StructType\ClockTimeType
     */
    public function setHours($hours = null)
    {
        // validation for constraint: int
        if (!is_null($hours) && !(is_int($hours) || ctype_digit($hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hours, true), gettype($hours)), __LINE__);
        }
        $this->hours = $hours;
        return $this;
    }
    /**
     * Get minutes value
     * @return int
     */
    public function getMinutes()
    {
        return $this->minutes;
    }
    /**
     * Set minutes value
     * @param int $minutes
     * @return \StructType\ClockTimeType
     */
    public function setMinutes($minutes = null)
    {
        // validation for constraint: int
        if (!is_null($minutes) && !(is_int($minutes) || ctype_digit($minutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minutes, true), gettype($minutes)), __LINE__);
        }
        $this->minutes = $minutes;
        return $this;
    }
    /**
     * Get seconds value
     * @return int
     */
    public function getSeconds()
    {
        return $this->seconds;
    }
    /**
     * Set seconds value
     * @param int $seconds
     * @return \StructType\ClockTimeType
     */
    public function setSeconds($seconds = null)
    {
        // validation for constraint: int
        if (!is_null($seconds) && !(is_int($seconds) || ctype_digit($seconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seconds, true), gettype($seconds)), __LINE__);
        }
        $this->seconds = $seconds;
        return $this;
    }
}
