<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnswerContainerType StructType
 * Meta information extracted from the WSDL
 * - documentation: Class representing AnswerContainerType
 * @subpackage Structs
 */
class AnswerContainerType extends TaskContainerType
{
    /**
     * The referencedNotificationID
     * Meta information extracted from the WSDL
     * - documentation: como referencedNotificationID
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $referencedNotificationID;
    /**
     * The serverResponseType
     * Meta information extracted from the WSDL
     * - documentation: como referencedNotificationID
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $serverResponseType;
    /**
     * Constructor method for AnswerContainerType
     * @uses AnswerContainerType::setReferencedNotificationID()
     * @uses AnswerContainerType::setServerResponseType()
     * @param int $referencedNotificationID
     * @param string $serverResponseType
     */
    public function __construct($referencedNotificationID = null, $serverResponseType = null)
    {
        $this
            ->setReferencedNotificationID($referencedNotificationID)
            ->setServerResponseType($serverResponseType);
    }
    /**
     * Get referencedNotificationID value
     * @return int
     */
    public function getReferencedNotificationID()
    {
        return $this->referencedNotificationID;
    }
    /**
     * Set referencedNotificationID value
     * @param int $referencedNotificationID
     * @return \StructType\AnswerContainerType
     */
    public function setReferencedNotificationID($referencedNotificationID = null)
    {
        // validation for constraint: int
        if (!is_null($referencedNotificationID) && !(is_int($referencedNotificationID) || ctype_digit($referencedNotificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referencedNotificationID, true), gettype($referencedNotificationID)), __LINE__);
        }
        $this->referencedNotificationID = $referencedNotificationID;
        return $this;
    }
    /**
     * Get serverResponseType value
     * @return string
     */
    public function getServerResponseType()
    {
        return $this->serverResponseType;
    }
    /**
     * Set serverResponseType value
     * @param string $serverResponseType
     * @return \StructType\AnswerContainerType
     */
    public function setServerResponseType($serverResponseType = null)
    {
        // validation for constraint: string
        if (!is_null($serverResponseType) && !is_string($serverResponseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverResponseType, true), gettype($serverResponseType)), __LINE__);
        }
        $this->serverResponseType = $serverResponseType;
        return $this;
    }
}
