<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unset ServiceType
 * @subpackage Services
 */
class _Unset extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named unsetObj
     * Meta information extracted from the WSDL
     * - documentation: unset obj
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param int|string $int|string
     * @return void|bool
     */
    public function unsetObj($int_string)
    {
        try {
            $this->setResult($this->getSoapClient()->unsetObj($int_string));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named unsetDigitalInputPort
     * Meta information extracted from the WSDL
     * - documentation: unset digitalInputPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param int|string $int|string
     * @return void|bool
     */
    public function unsetDigitalInputPort($int_string)
    {
        try {
            $this->setResult($this->getSoapClient()->unsetDigitalInputPort($int_string));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
