<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Isset ServiceType
 * @subpackage Services
 */
class _Isset extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named issetObj
     * Meta information extracted from the WSDL
     * - documentation: isset obj
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param int|string $int|string
     * @return bool|bool
     */
    public function issetObj($int_string)
    {
        try {
            $this->setResult($this->getSoapClient()->issetObj($int_string));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named issetDigitalInputPort
     * Meta information extracted from the WSDL
     * - documentation: isset digitalInputPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param int|string $int|string
     * @return bool|bool
     */
    public function issetDigitalInputPort($int_string)
    {
        try {
            $this->setResult($this->getSoapClient()->issetDigitalInputPort($int_string));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return bool
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
