<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named setBinData
     * Meta information extracted from the WSDL
     * - documentation: Sets a new binData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param mixed $mixed
     * @return self|bool
     */
    public function setBinData($mixed)
    {
        try {
            $this->setResult($this->getSoapClient()->setBinData($mixed));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCameraImages
     * Meta information extracted from the WSDL
     * - documentation: Sets a new cameraImages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\BinaryDataType $\Counter\PushService\BinaryDataType
     * @return self|bool
     */
    public function setCameraImages($_Counter_PushService_BinaryDataType)
    {
        try {
            $this->setResult($this->getSoapClient()->setCameraImages($_Counter_PushService_BinaryDataType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setEvalMap
     * Meta information extracted from the WSDL
     * - documentation: Sets a new evalMap
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\BinaryDataType $\Counter\PushService\BinaryDataType
     * @return self|bool
     */
    public function setEvalMap($_Counter_PushService_BinaryDataType)
    {
        try {
            $this->setResult($this->getSoapClient()->setEvalMap($_Counter_PushService_BinaryDataType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setIsBlocked
     * Meta information extracted from the WSDL
     * - documentation: Sets a new isBlocked
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param bool $bool
     * @return self|bool
     */
    public function setIsBlocked($bool)
    {
        try {
            $this->setResult($this->getSoapClient()->setIsBlocked($bool));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setClearZoneId
     * Meta information extracted from the WSDL
     * - documentation: Sets a new clearZoneId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\ClearZoneIDType $\Counter\PushService\ClearZoneIDType
     * @return self|bool
     */
    public function setClearZoneId($_Counter_PushService_ClearZoneIDType)
    {
        try {
            $this->setResult($this->getSoapClient()->setClearZoneId($_Counter_PushService_ClearZoneIDType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setX
     * Meta information extracted from the WSDL
     * - documentation: Sets a new x
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $x
     * @return self|bool
     */
    public function setX($x)
    {
        try {
            $this->setResult($this->getSoapClient()->setX($x));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setY
     * Meta information extracted from the WSDL
     * - documentation: Sets a new y
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $y
     * @return self|bool
     */
    public function setY($y)
    {
        try {
            $this->setResult($this->getSoapClient()->setY($y));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setZ
     * Meta information extracted from the WSDL
     * - documentation: Sets a new z
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $z
     * @return self|bool
     */
    public function setZ($z)
    {
        try {
            $this->setResult($this->getSoapClient()->setZ($z));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCountIn
     * Meta information extracted from the WSDL
     * - documentation: Sets a new countIn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $countIn
     * @return self|bool
     */
    public function setCountIn($countIn)
    {
        try {
            $this->setResult($this->getSoapClient()->setCountIn($countIn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCountOut
     * Meta information extracted from the WSDL
     * - documentation: Sets a new countOut
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $countOut
     * @return self|bool
     */
    public function setCountOut($countOut)
    {
        try {
            $this->setResult($this->getSoapClient()->setCountOut($countOut));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCountingGateId
     * Meta information extracted from the WSDL
     * - documentation: Sets a new countingGateId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\CountingGateIDType $\Counter\PushService\CountingGateIDType
     * @return self|bool
     */
    public function setCountingGateId($_Counter_PushService_CountingGateIDType)
    {
        try {
            $this->setResult($this->getSoapClient()->setCountingGateId($_Counter_PushService_CountingGateIDType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObj
     * Meta information extracted from the WSDL
     * - documentation: Sets a new obj
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\CurrentObjectType[] $\Counter\PushService\CurrentObjectType[]
     * @return self|bool
     */
    public function setObj($_Counter_PushService_CurrentObjectType__)
    {
        try {
            $this->setResult($this->getSoapClient()->setObj($_Counter_PushService_CurrentObjectType__));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setBinaryData
     * Meta information extracted from the WSDL
     * - documentation: Sets a new binaryData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\BinaryDataType $\Counter\PushService\BinaryDataType
     * @return self|bool
     */
    public function setBinaryData($_Counter_PushService_BinaryDataType)
    {
        try {
            $this->setResult($this->getSoapClient()->setBinaryData($_Counter_PushService_BinaryDataType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPos
     * Meta information extracted from the WSDL
     * - documentation: Sets a new pos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\Coordinate3DType $\Counter\PushService\Coordinate3DType
     * @return self|bool
     */
    public function setPos($_Counter_PushService_Coordinate3DType)
    {
        try {
            $this->setResult($this->getSoapClient()->setPos($_Counter_PushService_Coordinate3DType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setMov
     * Meta information extracted from the WSDL
     * - documentation: Sets a new mov
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\Coordinate2DType $\Counter\PushService\Coordinate2DType
     * @return self|bool
     */
    public function setMov($_Counter_PushService_Coordinate2DType)
    {
        try {
            $this->setResult($this->getSoapClient()->setMov($_Counter_PushService_Coordinate2DType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setActivityState
     * Meta information extracted from the WSDL
     * - documentation: Sets a new activityState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param bool $bool
     * @return self|bool
     */
    public function setActivityState($bool)
    {
        try {
            $this->setResult($this->getSoapClient()->setActivityState($bool));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setValue
     * Meta information extracted from the WSDL
     * - documentation: Sets a new value
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $value
     * @return self|bool
     */
    public function setValue($value)
    {
        try {
            $this->setResult($this->getSoapClient()->setValue($value));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setDigitalInputPort
     * Meta information extracted from the WSDL
     * - documentation: Sets a new digitalInputPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\DigitalInputElementType[] $\Counter\PushService\DigitalInputElementType[]
     * @return self|bool
     */
    public function setDigitalInputPort($_Counter_PushService_DigitalInputElementType__)
    {
        try {
            $this->setResult($this->getSoapClient()->setDigitalInputPort($_Counter_PushService_DigitalInputElementType__));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setErrorReason
     * Meta information extracted from the WSDL
     * - documentation: Sets a new errorReason
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $errorReason
     * @return self|bool
     */
    public function setErrorReason($errorReason)
    {
        try {
            $this->setResult($this->getSoapClient()->setErrorReason($errorReason));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setErrorText
     * Meta information extracted from the WSDL
     * - documentation: Sets a new errorText
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $errorText
     * @return self|bool
     */
    public function setErrorText($errorText)
    {
        try {
            $this->setResult($this->getSoapClient()->setErrorText($errorText));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setErrorLogData
     * Meta information extracted from the WSDL
     * - documentation: Sets a new errorLogData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\BinaryDataType $\Counter\PushService\BinaryDataType
     * @return self|bool
     */
    public function setErrorLogData($_Counter_PushService_BinaryDataType)
    {
        try {
            $this->setResult($this->getSoapClient()->setErrorLogData($_Counter_PushService_BinaryDataType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setIpAddress
     * Meta information extracted from the WSDL
     * - documentation: Sets a new ipAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $ipAddress
     * @return self|bool
     */
    public function setIpAddress($ipAddress)
    {
        try {
            $this->setResult($this->getSoapClient()->setIpAddress($ipAddress));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setFirmwareVersion
     * Meta information extracted from the WSDL
     * - documentation: Sets a new firmwareVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $firmwareVersion
     * @return self|bool
     */
    public function setFirmwareVersion($firmwareVersion)
    {
        try {
            $this->setResult($this->getSoapClient()->setFirmwareVersion($firmwareVersion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCustomerVersion
     * Meta information extracted from the WSDL
     * - documentation: Sets a new customerVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerVersion
     * @return self|bool
     */
    public function setCustomerVersion($customerVersion)
    {
        try {
            $this->setResult($this->getSoapClient()->setCustomerVersion($customerVersion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setFillLevel
     * Meta information extracted from the WSDL
     * - documentation: Sets a new fillLevel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $fillLevel
     * @return self|bool
     */
    public function setFillLevel($fillLevel)
    {
        try {
            $this->setResult($this->getSoapClient()->setFillLevel($fillLevel));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setFillRegionId
     * Meta information extracted from the WSDL
     * - documentation: Sets a new fillRegionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\FillRegionIDType $\Counter\PushService\FillRegionIDType
     * @return self|bool
     */
    public function setFillRegionId($_Counter_PushService_FillRegionIDType)
    {
        try {
            $this->setResult($this->getSoapClient()->setFillRegionId($_Counter_PushService_FillRegionIDType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setLostCount
     * Meta information extracted from the WSDL
     * - documentation: Sets a new lostCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $lostCount
     * @return self|bool
     */
    public function setLostCount($lostCount)
    {
        try {
            $this->setResult($this->getSoapClient()->setLostCount($lostCount));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setExitTime
     * Meta information extracted from the WSDL
     * - documentation: Sets a new exitTime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DateTime $\DateTime
     * @return self|bool
     */
    public function setExitTime($_DateTime)
    {
        try {
            $this->setResult($this->getSoapClient()->setExitTime($_DateTime));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setHeight
     * Meta information extracted from the WSDL
     * - documentation: Sets a new height
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $height
     * @return self|bool
     */
    public function setHeight($height)
    {
        try {
            $this->setResult($this->getSoapClient()->setHeight($height));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setExit
     * Meta information extracted from the WSDL
     * - documentation: Sets a new exit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\Coordinate3DType $\Counter\PushService\Coordinate3DType
     * @return self|bool
     */
    public function setExit($_Counter_PushService_Coordinate3DType)
    {
        try {
            $this->setResult($this->getSoapClient()->setExit($_Counter_PushService_Coordinate3DType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setLogData
     * Meta information extracted from the WSDL
     * - documentation: Sets a new logData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\BinaryDataType $\Counter\PushService\BinaryDataType
     * @return self|bool
     */
    public function setLogData($_Counter_PushService_BinaryDataType)
    {
        try {
            $this->setResult($this->getSoapClient()->setLogData($_Counter_PushService_BinaryDataType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setMacAddress
     * Meta information extracted from the WSDL
     * - documentation: Sets a new macAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $macAddress
     * @return self|bool
     */
    public function setMacAddress($macAddress)
    {
        try {
            $this->setResult($this->getSoapClient()->setMacAddress($macAddress));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCustomerID
     * Meta information extracted from the WSDL
     * - documentation: Sets a new customerID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerID
     * @return self|bool
     */
    public function setCustomerID($customerID)
    {
        try {
            $this->setResult($this->getSoapClient()->setCustomerID($customerID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setTaskType
     * Meta information extracted from the WSDL
     * - documentation: Sets a new taskType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $taskType
     * @return self|bool
     */
    public function setTaskType($taskType)
    {
        try {
            $this->setResult($this->getSoapClient()->setTaskType($taskType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setNotificationID
     * Meta information extracted from the WSDL
     * - documentation: Sets a new notificationID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $notificationID
     * @return self|bool
     */
    public function setNotificationID($notificationID)
    {
        try {
            $this->setResult($this->getSoapClient()->setNotificationID($notificationID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setServerTaskID
     * Meta information extracted from the WSDL
     * - documentation: Sets a new serverTaskID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $serverTaskID
     * @return self|bool
     */
    public function setServerTaskID($serverTaskID)
    {
        try {
            $this->setResult($this->getSoapClient()->setServerTaskID($serverTaskID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCallerTypeID
     * Meta information extracted from the WSDL
     * - documentation: Sets a new callerTypeID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $callerTypeID
     * @return self|bool
     */
    public function setCallerTypeID($callerTypeID)
    {
        try {
            $this->setResult($this->getSoapClient()->setCallerTypeID($callerTypeID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setTimestamp
     * Meta information extracted from the WSDL
     * - documentation: Sets a new timestamp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DateTime $\DateTime
     * @return self|bool
     */
    public function setTimestamp($_DateTime)
    {
        try {
            $this->setResult($this->getSoapClient()->setTimestamp($_DateTime));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCountNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new countNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\CountNotificationType $\Counter\PushService\CountNotificationType
     * @return self|bool
     */
    public function setCountNotification($_Counter_PushService_CountNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setCountNotification($_Counter_PushService_CountNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setFillNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new fillNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\FillNotificationType $\Counter\PushService\FillNotificationType
     * @return self|bool
     */
    public function setFillNotification($_Counter_PushService_FillNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setFillNotification($_Counter_PushService_FillNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setDigitalInputNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new digitalInputNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\DigitalInputNotificationType $\Counter\PushService\DigitalInputNotificationType
     * @return self|bool
     */
    public function setDigitalInputNotification($_Counter_PushService_DigitalInputNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setDigitalInputNotification($_Counter_PushService_DigitalInputNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCameraImagesNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new cameraImagesNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\CameraImagesNotificationType $\Counter\PushService\CameraImagesNotificationType
     * @return self|bool
     */
    public function setCameraImagesNotification($_Counter_PushService_CameraImagesNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setCameraImagesNotification($_Counter_PushService_CameraImagesNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setParameterNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new parameterNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\ParameterNotificationType $\Counter\PushService\ParameterNotificationType
     * @return self|bool
     */
    public function setParameterNotification($_Counter_PushService_ParameterNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setParameterNotification($_Counter_PushService_ParameterNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setLogfilesNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new logfilesNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\LogfilesNotificationType $\Counter\PushService\LogfilesNotificationType
     * @return self|bool
     */
    public function setLogfilesNotification($_Counter_PushService_LogfilesNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setLogfilesNotification($_Counter_PushService_LogfilesNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setErrorLogfilesNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new errorLogfilesNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\ErrorLogfilesNotificationType $\Counter\PushService\ErrorLogfilesNotificationType
     * @return self|bool
     */
    public function setErrorLogfilesNotification($_Counter_PushService_ErrorLogfilesNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setErrorLogfilesNotification($_Counter_PushService_ErrorLogfilesNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setAliveNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new aliveNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\AliveNotificationType $\Counter\PushService\AliveNotificationType
     * @return self|bool
     */
    public function setAliveNotification($_Counter_PushService_AliveNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setAliveNotification($_Counter_PushService_AliveNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCurrObjlistNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new currObjlistNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\CurrentObjectListNotificationType $\Counter\PushService\CurrentObjectListNotificationType
     * @return self|bool
     */
    public function setCurrObjlistNotification($_Counter_PushService_CurrentObjectListNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setCurrObjlistNotification($_Counter_PushService_CurrentObjectListNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setHistObjlistNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new histObjlistNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\HistoricObjectListNotificationType $\Counter\PushService\HistoricObjectListNotificationType
     * @return self|bool
     */
    public function setHistObjlistNotification($_Counter_PushService_HistoricObjectListNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setHistObjlistNotification($_Counter_PushService_HistoricObjectListNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setStartupNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new startupNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\StartupNotificationType $\Counter\PushService\StartupNotificationType
     * @return self|bool
     */
    public function setStartupNotification($_Counter_PushService_StartupNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setStartupNotification($_Counter_PushService_StartupNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setClearZoneNotification
     * Meta information extracted from the WSDL
     * - documentation: Sets a new clearZoneNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\ClearZoneNotificationType $\Counter\PushService\ClearZoneNotificationType
     * @return self|bool
     */
    public function setClearZoneNotification($_Counter_PushService_ClearZoneNotificationType)
    {
        try {
            $this->setResult($this->getSoapClient()->setClearZoneNotification($_Counter_PushService_ClearZoneNotificationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setOsdState
     * Meta information extracted from the WSDL
     * - documentation: Sets a new osdState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $osdState
     * @return self|bool
     */
    public function setOsdState($osdState)
    {
        try {
            $this->setResult($this->getSoapClient()->setOsdState($osdState));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setId
     * Meta information extracted from the WSDL
     * - documentation: Sets a new id
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $id
     * @return self|bool
     */
    public function setId($id)
    {
        try {
            $this->setResult($this->getSoapClient()->setId($id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setZone
     * Meta information extracted from the WSDL
     * - documentation: Sets a new zone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $zone
     * @return self|bool
     */
    public function setZone($zone)
    {
        try {
            $this->setResult($this->getSoapClient()->setZone($zone));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setDwell
     * Meta information extracted from the WSDL
     * - documentation: Sets a new dwell
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $dwell
     * @return self|bool
     */
    public function setDwell($dwell)
    {
        try {
            $this->setResult($this->getSoapClient()->setDwell($dwell));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setEntry
     * Meta information extracted from the WSDL
     * - documentation: Sets a new entry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\Coordinate3DType $\Counter\PushService\Coordinate3DType
     * @return self|bool
     */
    public function setEntry($_Counter_PushService_Coordinate3DType)
    {
        try {
            $this->setResult($this->getSoapClient()->setEntry($_Counter_PushService_Coordinate3DType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setParameterData
     * Meta information extracted from the WSDL
     * - documentation: Sets a new parameterData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\BinaryDataType $\Counter\PushService\BinaryDataType
     * @return self|bool
     */
    public function setParameterData($_Counter_PushService_BinaryDataType)
    {
        try {
            $this->setResult($this->getSoapClient()->setParameterData($_Counter_PushService_BinaryDataType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setRebootType
     * Meta information extracted from the WSDL
     * - documentation: Sets a new rebootType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $rebootType
     * @return self|bool
     */
    public function setRebootType($rebootType)
    {
        try {
            $this->setResult($this->getSoapClient()->setRebootType($rebootType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setDate
     * Meta information extracted from the WSDL
     * - documentation: Sets a new date
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\DateType $\Counter\PushService\DateType
     * @return self|bool
     */
    public function setDate($_Counter_PushService_DateType)
    {
        try {
            $this->setResult($this->getSoapClient()->setDate($_Counter_PushService_DateType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setStart
     * Meta information extracted from the WSDL
     * - documentation: Sets a new start
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\ClockTimeType $\Counter\PushService\ClockTimeType
     * @return self|bool
     */
    public function setStart($_Counter_PushService_ClockTimeType)
    {
        try {
            $this->setResult($this->getSoapClient()->setStart($_Counter_PushService_ClockTimeType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCycle
     * Meta information extracted from the WSDL
     * - documentation: Sets a new cycle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DateInterval $\DateInterval
     * @return self|bool
     */
    public function setCycle($_DateInterval)
    {
        try {
            $this->setResult($this->getSoapClient()->setCycle($_DateInterval));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setRandomOffset
     * Meta information extracted from the WSDL
     * - documentation: Sets a new randomOffset
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DateInterval $\DateInterval
     * @return self|bool
     */
    public function setRandomOffset($_DateInterval)
    {
        try {
            $this->setResult($this->getSoapClient()->setRandomOffset($_DateInterval));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return self
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
