<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Notificationmessage ServiceType
 * @subpackage Services
 */
class Notificationmessage extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named notification_message
     * Meta information extracted from the WSDL
     * - documentation: Mensaje SOAP.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $xml
     * @return \StructType\AnswerMessage|bool
     */
    public function notification_message($xml)
    {
        try {
            $this->setResult($this->getSoapClient()->notification_message($xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AnswerMessage
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
