<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addToObj
     * Meta information extracted from the WSDL
     * - documentation: Adds as obj
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\CurrentObjectType $\Counter\PushService\CurrentObjectType
     * @return self|bool
     */
    public function addToObj($_Counter_PushService_CurrentObjectType)
    {
        try {
            $this->setResult($this->getSoapClient()->addToObj($_Counter_PushService_CurrentObjectType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addToDigitalInputPort
     * Meta information extracted from the WSDL
     * - documentation: Adds as digitalInputPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Counter\PushService\DigitalInputElementType $\Counter\PushService\DigitalInputElementType
     * @return self|bool
     */
    public function addToDigitalInputPort($_Counter_PushService_DigitalInputElementType)
    {
        try {
            $this->setResult($this->getSoapClient()->addToDigitalInputPort($_Counter_PushService_DigitalInputElementType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return self
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
