<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for phone StructType
 * @subpackage Structs
 */
class Phone extends AbstractStructBase
{
    /**
     * The phone_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $phone_id;
    /**
     * The member_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $member_id;
    /**
     * The okay_to_use_flag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $okay_to_use_flag;
    /**
     * The phone_type_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phone_type_code;
    /**
     * The phone_type_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phone_type_name;
    /**
     * The primary_phone_flag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primary_phone_flag;
    /**
     * The area_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $area_code;
    /**
     * The phone_number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phone_number;
    /**
     * The extension_number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $extension_number;
    /**
     * The international_number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $international_number;
    /**
     * The domestic_flag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domestic_flag;
    /**
     * The formatted_number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $formatted_number;
    /**
     * Constructor method for phone
     * @uses Phone::setPhone_id()
     * @uses Phone::setMember_id()
     * @uses Phone::setOkay_to_use_flag()
     * @uses Phone::setPhone_type_code()
     * @uses Phone::setPhone_type_name()
     * @uses Phone::setPrimary_phone_flag()
     * @uses Phone::setArea_code()
     * @uses Phone::setPhone_number()
     * @uses Phone::setExtension_number()
     * @uses Phone::setInternational_number()
     * @uses Phone::setDomestic_flag()
     * @uses Phone::setFormatted_number()
     * @param int $phone_id
     * @param string $member_id
     * @param string $okay_to_use_flag
     * @param string $phone_type_code
     * @param string $phone_type_name
     * @param string $primary_phone_flag
     * @param string $area_code
     * @param string $phone_number
     * @param string $extension_number
     * @param string $international_number
     * @param string $domestic_flag
     * @param string $formatted_number
     */
    public function __construct($phone_id = null, $member_id = null, $okay_to_use_flag = null, $phone_type_code = null, $phone_type_name = null, $primary_phone_flag = null, $area_code = null, $phone_number = null, $extension_number = null, $international_number = null, $domestic_flag = null, $formatted_number = null)
    {
        $this
            ->setPhone_id($phone_id)
            ->setMember_id($member_id)
            ->setOkay_to_use_flag($okay_to_use_flag)
            ->setPhone_type_code($phone_type_code)
            ->setPhone_type_name($phone_type_name)
            ->setPrimary_phone_flag($primary_phone_flag)
            ->setArea_code($area_code)
            ->setPhone_number($phone_number)
            ->setExtension_number($extension_number)
            ->setInternational_number($international_number)
            ->setDomestic_flag($domestic_flag)
            ->setFormatted_number($formatted_number);
    }
    /**
     * Get phone_id value
     * @return int
     */
    public function getPhone_id()
    {
        return $this->phone_id;
    }
    /**
     * Set phone_id value
     * @param int $phone_id
     * @return \StructType\Phone
     */
    public function setPhone_id($phone_id = null)
    {
        // validation for constraint: int
        if (!is_null($phone_id) && !(is_int($phone_id) || ctype_digit($phone_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($phone_id, true), gettype($phone_id)), __LINE__);
        }
        $this->phone_id = $phone_id;
        return $this;
    }
    /**
     * Get member_id value
     * @return string|null
     */
    public function getMember_id()
    {
        return $this->member_id;
    }
    /**
     * Set member_id value
     * @param string $member_id
     * @return \StructType\Phone
     */
    public function setMember_id($member_id = null)
    {
        // validation for constraint: string
        if (!is_null($member_id) && !is_string($member_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($member_id, true), gettype($member_id)), __LINE__);
        }
        $this->member_id = $member_id;
        return $this;
    }
    /**
     * Get okay_to_use_flag value
     * @return string|null
     */
    public function getOkay_to_use_flag()
    {
        return $this->okay_to_use_flag;
    }
    /**
     * Set okay_to_use_flag value
     * @param string $okay_to_use_flag
     * @return \StructType\Phone
     */
    public function setOkay_to_use_flag($okay_to_use_flag = null)
    {
        // validation for constraint: string
        if (!is_null($okay_to_use_flag) && !is_string($okay_to_use_flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($okay_to_use_flag, true), gettype($okay_to_use_flag)), __LINE__);
        }
        $this->okay_to_use_flag = $okay_to_use_flag;
        return $this;
    }
    /**
     * Get phone_type_code value
     * @return string|null
     */
    public function getPhone_type_code()
    {
        return $this->phone_type_code;
    }
    /**
     * Set phone_type_code value
     * @param string $phone_type_code
     * @return \StructType\Phone
     */
    public function setPhone_type_code($phone_type_code = null)
    {
        // validation for constraint: string
        if (!is_null($phone_type_code) && !is_string($phone_type_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_type_code, true), gettype($phone_type_code)), __LINE__);
        }
        $this->phone_type_code = $phone_type_code;
        return $this;
    }
    /**
     * Get phone_type_name value
     * @return string|null
     */
    public function getPhone_type_name()
    {
        return $this->phone_type_name;
    }
    /**
     * Set phone_type_name value
     * @param string $phone_type_name
     * @return \StructType\Phone
     */
    public function setPhone_type_name($phone_type_name = null)
    {
        // validation for constraint: string
        if (!is_null($phone_type_name) && !is_string($phone_type_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_type_name, true), gettype($phone_type_name)), __LINE__);
        }
        $this->phone_type_name = $phone_type_name;
        return $this;
    }
    /**
     * Get primary_phone_flag value
     * @return string|null
     */
    public function getPrimary_phone_flag()
    {
        return $this->primary_phone_flag;
    }
    /**
     * Set primary_phone_flag value
     * @param string $primary_phone_flag
     * @return \StructType\Phone
     */
    public function setPrimary_phone_flag($primary_phone_flag = null)
    {
        // validation for constraint: string
        if (!is_null($primary_phone_flag) && !is_string($primary_phone_flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primary_phone_flag, true), gettype($primary_phone_flag)), __LINE__);
        }
        $this->primary_phone_flag = $primary_phone_flag;
        return $this;
    }
    /**
     * Get area_code value
     * @return string|null
     */
    public function getArea_code()
    {
        return $this->area_code;
    }
    /**
     * Set area_code value
     * @param string $area_code
     * @return \StructType\Phone
     */
    public function setArea_code($area_code = null)
    {
        // validation for constraint: string
        if (!is_null($area_code) && !is_string($area_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area_code, true), gettype($area_code)), __LINE__);
        }
        $this->area_code = $area_code;
        return $this;
    }
    /**
     * Get phone_number value
     * @return string|null
     */
    public function getPhone_number()
    {
        return $this->phone_number;
    }
    /**
     * Set phone_number value
     * @param string $phone_number
     * @return \StructType\Phone
     */
    public function setPhone_number($phone_number = null)
    {
        // validation for constraint: string
        if (!is_null($phone_number) && !is_string($phone_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_number, true), gettype($phone_number)), __LINE__);
        }
        $this->phone_number = $phone_number;
        return $this;
    }
    /**
     * Get extension_number value
     * @return string|null
     */
    public function getExtension_number()
    {
        return $this->extension_number;
    }
    /**
     * Set extension_number value
     * @param string $extension_number
     * @return \StructType\Phone
     */
    public function setExtension_number($extension_number = null)
    {
        // validation for constraint: string
        if (!is_null($extension_number) && !is_string($extension_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension_number, true), gettype($extension_number)), __LINE__);
        }
        $this->extension_number = $extension_number;
        return $this;
    }
    /**
     * Get international_number value
     * @return string|null
     */
    public function getInternational_number()
    {
        return $this->international_number;
    }
    /**
     * Set international_number value
     * @param string $international_number
     * @return \StructType\Phone
     */
    public function setInternational_number($international_number = null)
    {
        // validation for constraint: string
        if (!is_null($international_number) && !is_string($international_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($international_number, true), gettype($international_number)), __LINE__);
        }
        $this->international_number = $international_number;
        return $this;
    }
    /**
     * Get domestic_flag value
     * @return string|null
     */
    public function getDomestic_flag()
    {
        return $this->domestic_flag;
    }
    /**
     * Set domestic_flag value
     * @param string $domestic_flag
     * @return \StructType\Phone
     */
    public function setDomestic_flag($domestic_flag = null)
    {
        // validation for constraint: string
        if (!is_null($domestic_flag) && !is_string($domestic_flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domestic_flag, true), gettype($domestic_flag)), __LINE__);
        }
        $this->domestic_flag = $domestic_flag;
        return $this;
    }
    /**
     * Get formatted_number value
     * @return string|null
     */
    public function getFormatted_number()
    {
        return $this->formatted_number;
    }
    /**
     * Set formatted_number value
     * @param string $formatted_number
     * @return \StructType\Phone
     */
    public function setFormatted_number($formatted_number = null)
    {
        // validation for constraint: string
        if (!is_null($formatted_number) && !is_string($formatted_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formatted_number, true), gettype($formatted_number)), __LINE__);
        }
        $this->formatted_number = $formatted_number;
        return $this;
    }
}
