<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for award StructType
 * @subpackage Structs
 */
class Award extends AbstractStructBase
{
    /**
     * The award_expiry_date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $award_expiry_date;
    /**
     * The trophy_point_value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $trophy_point_value;
    /**
     * The current_for_months
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $current_for_months;
    /**
     * The current_till_date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $current_till_date;
    /**
     * The recertified_by_recert_level
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $recertified_by_recert_level;
    /**
     * The award_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $award_code;
    /**
     * The award_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $award_name;
    /**
     * The printed_via_card_queue_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $printed_via_card_queue_name;
    /**
     * The award_type_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $award_type_code;
    /**
     * The water_award_type_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $water_award_type_code;
    /**
     * The option_recert_text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $option_recert_text;
    /**
     * The payment_type_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payment_type_code;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * The accounting_pass_item_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accounting_pass_item_code;
    /**
     * The accounting_fail_item_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accounting_fail_item_code;
    /**
     * The sort_order_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sort_order_code;
    /**
     * The promote_to_individual_type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $promote_to_individual_type;
    /**
     * The web_category_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $web_category_code;
    /**
     * The award_card_text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $award_card_text;
    /**
     * The investigation_card_text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $investigation_card_text;
    /**
     * The certification_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certification_code;
    /**
     * The recert_by_award_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recert_by_award_code;
    /**
     * The french_award_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $french_award_name;
    /**
     * The french_option_recert_text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $french_option_recert_text;
    /**
     * The french_award_card_text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $french_award_card_text;
    /**
     * The french_investigation_card_text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $french_investigation_card_text;
    /**
     * The award_stream_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $award_stream_code;
    /**
     * The instructor_required_flag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $instructor_required_flag;
    /**
     * The system_code_flag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $system_code_flag;
    /**
     * The national_award
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $national_award;
    /**
     * Constructor method for award
     * @uses Award::setAward_expiry_date()
     * @uses Award::setTrophy_point_value()
     * @uses Award::setCurrent_for_months()
     * @uses Award::setCurrent_till_date()
     * @uses Award::setRecertified_by_recert_level()
     * @uses Award::setAward_code()
     * @uses Award::setAward_name()
     * @uses Award::setPrinted_via_card_queue_name()
     * @uses Award::setAward_type_code()
     * @uses Award::setWater_award_type_code()
     * @uses Award::setOption_recert_text()
     * @uses Award::setPayment_type_code()
     * @uses Award::setComments()
     * @uses Award::setAccounting_pass_item_code()
     * @uses Award::setAccounting_fail_item_code()
     * @uses Award::setSort_order_code()
     * @uses Award::setPromote_to_individual_type()
     * @uses Award::setWeb_category_code()
     * @uses Award::setAward_card_text()
     * @uses Award::setInvestigation_card_text()
     * @uses Award::setCertification_code()
     * @uses Award::setRecert_by_award_code()
     * @uses Award::setFrench_award_name()
     * @uses Award::setFrench_option_recert_text()
     * @uses Award::setFrench_award_card_text()
     * @uses Award::setFrench_investigation_card_text()
     * @uses Award::setAward_stream_code()
     * @uses Award::setInstructor_required_flag()
     * @uses Award::setSystem_code_flag()
     * @uses Award::setNational_award()
     * @param string $award_expiry_date
     * @param int $trophy_point_value
     * @param int $current_for_months
     * @param string $current_till_date
     * @param string $recertified_by_recert_level
     * @param string $award_code
     * @param string $award_name
     * @param string $printed_via_card_queue_name
     * @param string $award_type_code
     * @param string $water_award_type_code
     * @param string $option_recert_text
     * @param string $payment_type_code
     * @param string $comments
     * @param string $accounting_pass_item_code
     * @param string $accounting_fail_item_code
     * @param string $sort_order_code
     * @param string $promote_to_individual_type
     * @param string $web_category_code
     * @param string $award_card_text
     * @param string $investigation_card_text
     * @param string $certification_code
     * @param string $recert_by_award_code
     * @param string $french_award_name
     * @param string $french_option_recert_text
     * @param string $french_award_card_text
     * @param string $french_investigation_card_text
     * @param string $award_stream_code
     * @param string $instructor_required_flag
     * @param string $system_code_flag
     * @param string $national_award
     */
    public function __construct($award_expiry_date = null, $trophy_point_value = null, $current_for_months = null, $current_till_date = null, $recertified_by_recert_level = null, $award_code = null, $award_name = null, $printed_via_card_queue_name = null, $award_type_code = null, $water_award_type_code = null, $option_recert_text = null, $payment_type_code = null, $comments = null, $accounting_pass_item_code = null, $accounting_fail_item_code = null, $sort_order_code = null, $promote_to_individual_type = null, $web_category_code = null, $award_card_text = null, $investigation_card_text = null, $certification_code = null, $recert_by_award_code = null, $french_award_name = null, $french_option_recert_text = null, $french_award_card_text = null, $french_investigation_card_text = null, $award_stream_code = null, $instructor_required_flag = null, $system_code_flag = null, $national_award = null)
    {
        $this
            ->setAward_expiry_date($award_expiry_date)
            ->setTrophy_point_value($trophy_point_value)
            ->setCurrent_for_months($current_for_months)
            ->setCurrent_till_date($current_till_date)
            ->setRecertified_by_recert_level($recertified_by_recert_level)
            ->setAward_code($award_code)
            ->setAward_name($award_name)
            ->setPrinted_via_card_queue_name($printed_via_card_queue_name)
            ->setAward_type_code($award_type_code)
            ->setWater_award_type_code($water_award_type_code)
            ->setOption_recert_text($option_recert_text)
            ->setPayment_type_code($payment_type_code)
            ->setComments($comments)
            ->setAccounting_pass_item_code($accounting_pass_item_code)
            ->setAccounting_fail_item_code($accounting_fail_item_code)
            ->setSort_order_code($sort_order_code)
            ->setPromote_to_individual_type($promote_to_individual_type)
            ->setWeb_category_code($web_category_code)
            ->setAward_card_text($award_card_text)
            ->setInvestigation_card_text($investigation_card_text)
            ->setCertification_code($certification_code)
            ->setRecert_by_award_code($recert_by_award_code)
            ->setFrench_award_name($french_award_name)
            ->setFrench_option_recert_text($french_option_recert_text)
            ->setFrench_award_card_text($french_award_card_text)
            ->setFrench_investigation_card_text($french_investigation_card_text)
            ->setAward_stream_code($award_stream_code)
            ->setInstructor_required_flag($instructor_required_flag)
            ->setSystem_code_flag($system_code_flag)
            ->setNational_award($national_award);
    }
    /**
     * Get award_expiry_date value
     * @return string
     */
    public function getAward_expiry_date()
    {
        return $this->award_expiry_date;
    }
    /**
     * Set award_expiry_date value
     * @param string $award_expiry_date
     * @return \StructType\Award
     */
    public function setAward_expiry_date($award_expiry_date = null)
    {
        // validation for constraint: string
        if (!is_null($award_expiry_date) && !is_string($award_expiry_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($award_expiry_date, true), gettype($award_expiry_date)), __LINE__);
        }
        $this->award_expiry_date = $award_expiry_date;
        return $this;
    }
    /**
     * Get trophy_point_value value
     * @return int
     */
    public function getTrophy_point_value()
    {
        return $this->trophy_point_value;
    }
    /**
     * Set trophy_point_value value
     * @param int $trophy_point_value
     * @return \StructType\Award
     */
    public function setTrophy_point_value($trophy_point_value = null)
    {
        // validation for constraint: int
        if (!is_null($trophy_point_value) && !(is_int($trophy_point_value) || ctype_digit($trophy_point_value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trophy_point_value, true), gettype($trophy_point_value)), __LINE__);
        }
        $this->trophy_point_value = $trophy_point_value;
        return $this;
    }
    /**
     * Get current_for_months value
     * @return int
     */
    public function getCurrent_for_months()
    {
        return $this->current_for_months;
    }
    /**
     * Set current_for_months value
     * @param int $current_for_months
     * @return \StructType\Award
     */
    public function setCurrent_for_months($current_for_months = null)
    {
        // validation for constraint: int
        if (!is_null($current_for_months) && !(is_int($current_for_months) || ctype_digit($current_for_months))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($current_for_months, true), gettype($current_for_months)), __LINE__);
        }
        $this->current_for_months = $current_for_months;
        return $this;
    }
    /**
     * Get current_till_date value
     * @return string
     */
    public function getCurrent_till_date()
    {
        return $this->current_till_date;
    }
    /**
     * Set current_till_date value
     * @param string $current_till_date
     * @return \StructType\Award
     */
    public function setCurrent_till_date($current_till_date = null)
    {
        // validation for constraint: string
        if (!is_null($current_till_date) && !is_string($current_till_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($current_till_date, true), gettype($current_till_date)), __LINE__);
        }
        $this->current_till_date = $current_till_date;
        return $this;
    }
    /**
     * Get recertified_by_recert_level value
     * @return string
     */
    public function getRecertified_by_recert_level()
    {
        return $this->recertified_by_recert_level;
    }
    /**
     * Set recertified_by_recert_level value
     * @param string $recertified_by_recert_level
     * @return \StructType\Award
     */
    public function setRecertified_by_recert_level($recertified_by_recert_level = null)
    {
        // validation for constraint: string
        if (!is_null($recertified_by_recert_level) && !is_string($recertified_by_recert_level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recertified_by_recert_level, true), gettype($recertified_by_recert_level)), __LINE__);
        }
        $this->recertified_by_recert_level = $recertified_by_recert_level;
        return $this;
    }
    /**
     * Get award_code value
     * @return string|null
     */
    public function getAward_code()
    {
        return $this->award_code;
    }
    /**
     * Set award_code value
     * @param string $award_code
     * @return \StructType\Award
     */
    public function setAward_code($award_code = null)
    {
        // validation for constraint: string
        if (!is_null($award_code) && !is_string($award_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($award_code, true), gettype($award_code)), __LINE__);
        }
        $this->award_code = $award_code;
        return $this;
    }
    /**
     * Get award_name value
     * @return string|null
     */
    public function getAward_name()
    {
        return $this->award_name;
    }
    /**
     * Set award_name value
     * @param string $award_name
     * @return \StructType\Award
     */
    public function setAward_name($award_name = null)
    {
        // validation for constraint: string
        if (!is_null($award_name) && !is_string($award_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($award_name, true), gettype($award_name)), __LINE__);
        }
        $this->award_name = $award_name;
        return $this;
    }
    /**
     * Get printed_via_card_queue_name value
     * @return string|null
     */
    public function getPrinted_via_card_queue_name()
    {
        return $this->printed_via_card_queue_name;
    }
    /**
     * Set printed_via_card_queue_name value
     * @param string $printed_via_card_queue_name
     * @return \StructType\Award
     */
    public function setPrinted_via_card_queue_name($printed_via_card_queue_name = null)
    {
        // validation for constraint: string
        if (!is_null($printed_via_card_queue_name) && !is_string($printed_via_card_queue_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printed_via_card_queue_name, true), gettype($printed_via_card_queue_name)), __LINE__);
        }
        $this->printed_via_card_queue_name = $printed_via_card_queue_name;
        return $this;
    }
    /**
     * Get award_type_code value
     * @return string|null
     */
    public function getAward_type_code()
    {
        return $this->award_type_code;
    }
    /**
     * Set award_type_code value
     * @param string $award_type_code
     * @return \StructType\Award
     */
    public function setAward_type_code($award_type_code = null)
    {
        // validation for constraint: string
        if (!is_null($award_type_code) && !is_string($award_type_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($award_type_code, true), gettype($award_type_code)), __LINE__);
        }
        $this->award_type_code = $award_type_code;
        return $this;
    }
    /**
     * Get water_award_type_code value
     * @return string|null
     */
    public function getWater_award_type_code()
    {
        return $this->water_award_type_code;
    }
    /**
     * Set water_award_type_code value
     * @param string $water_award_type_code
     * @return \StructType\Award
     */
    public function setWater_award_type_code($water_award_type_code = null)
    {
        // validation for constraint: string
        if (!is_null($water_award_type_code) && !is_string($water_award_type_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($water_award_type_code, true), gettype($water_award_type_code)), __LINE__);
        }
        $this->water_award_type_code = $water_award_type_code;
        return $this;
    }
    /**
     * Get option_recert_text value
     * @return string|null
     */
    public function getOption_recert_text()
    {
        return $this->option_recert_text;
    }
    /**
     * Set option_recert_text value
     * @param string $option_recert_text
     * @return \StructType\Award
     */
    public function setOption_recert_text($option_recert_text = null)
    {
        // validation for constraint: string
        if (!is_null($option_recert_text) && !is_string($option_recert_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($option_recert_text, true), gettype($option_recert_text)), __LINE__);
        }
        $this->option_recert_text = $option_recert_text;
        return $this;
    }
    /**
     * Get payment_type_code value
     * @return string|null
     */
    public function getPayment_type_code()
    {
        return $this->payment_type_code;
    }
    /**
     * Set payment_type_code value
     * @param string $payment_type_code
     * @return \StructType\Award
     */
    public function setPayment_type_code($payment_type_code = null)
    {
        // validation for constraint: string
        if (!is_null($payment_type_code) && !is_string($payment_type_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_type_code, true), gettype($payment_type_code)), __LINE__);
        }
        $this->payment_type_code = $payment_type_code;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\Award
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get accounting_pass_item_code value
     * @return string|null
     */
    public function getAccounting_pass_item_code()
    {
        return $this->accounting_pass_item_code;
    }
    /**
     * Set accounting_pass_item_code value
     * @param string $accounting_pass_item_code
     * @return \StructType\Award
     */
    public function setAccounting_pass_item_code($accounting_pass_item_code = null)
    {
        // validation for constraint: string
        if (!is_null($accounting_pass_item_code) && !is_string($accounting_pass_item_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounting_pass_item_code, true), gettype($accounting_pass_item_code)), __LINE__);
        }
        $this->accounting_pass_item_code = $accounting_pass_item_code;
        return $this;
    }
    /**
     * Get accounting_fail_item_code value
     * @return string|null
     */
    public function getAccounting_fail_item_code()
    {
        return $this->accounting_fail_item_code;
    }
    /**
     * Set accounting_fail_item_code value
     * @param string $accounting_fail_item_code
     * @return \StructType\Award
     */
    public function setAccounting_fail_item_code($accounting_fail_item_code = null)
    {
        // validation for constraint: string
        if (!is_null($accounting_fail_item_code) && !is_string($accounting_fail_item_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounting_fail_item_code, true), gettype($accounting_fail_item_code)), __LINE__);
        }
        $this->accounting_fail_item_code = $accounting_fail_item_code;
        return $this;
    }
    /**
     * Get sort_order_code value
     * @return string|null
     */
    public function getSort_order_code()
    {
        return $this->sort_order_code;
    }
    /**
     * Set sort_order_code value
     * @param string $sort_order_code
     * @return \StructType\Award
     */
    public function setSort_order_code($sort_order_code = null)
    {
        // validation for constraint: string
        if (!is_null($sort_order_code) && !is_string($sort_order_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sort_order_code, true), gettype($sort_order_code)), __LINE__);
        }
        $this->sort_order_code = $sort_order_code;
        return $this;
    }
    /**
     * Get promote_to_individual_type value
     * @return string|null
     */
    public function getPromote_to_individual_type()
    {
        return $this->promote_to_individual_type;
    }
    /**
     * Set promote_to_individual_type value
     * @param string $promote_to_individual_type
     * @return \StructType\Award
     */
    public function setPromote_to_individual_type($promote_to_individual_type = null)
    {
        // validation for constraint: string
        if (!is_null($promote_to_individual_type) && !is_string($promote_to_individual_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promote_to_individual_type, true), gettype($promote_to_individual_type)), __LINE__);
        }
        $this->promote_to_individual_type = $promote_to_individual_type;
        return $this;
    }
    /**
     * Get web_category_code value
     * @return string|null
     */
    public function getWeb_category_code()
    {
        return $this->web_category_code;
    }
    /**
     * Set web_category_code value
     * @param string $web_category_code
     * @return \StructType\Award
     */
    public function setWeb_category_code($web_category_code = null)
    {
        // validation for constraint: string
        if (!is_null($web_category_code) && !is_string($web_category_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_category_code, true), gettype($web_category_code)), __LINE__);
        }
        $this->web_category_code = $web_category_code;
        return $this;
    }
    /**
     * Get award_card_text value
     * @return string|null
     */
    public function getAward_card_text()
    {
        return $this->award_card_text;
    }
    /**
     * Set award_card_text value
     * @param string $award_card_text
     * @return \StructType\Award
     */
    public function setAward_card_text($award_card_text = null)
    {
        // validation for constraint: string
        if (!is_null($award_card_text) && !is_string($award_card_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($award_card_text, true), gettype($award_card_text)), __LINE__);
        }
        $this->award_card_text = $award_card_text;
        return $this;
    }
    /**
     * Get investigation_card_text value
     * @return string|null
     */
    public function getInvestigation_card_text()
    {
        return $this->investigation_card_text;
    }
    /**
     * Set investigation_card_text value
     * @param string $investigation_card_text
     * @return \StructType\Award
     */
    public function setInvestigation_card_text($investigation_card_text = null)
    {
        // validation for constraint: string
        if (!is_null($investigation_card_text) && !is_string($investigation_card_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($investigation_card_text, true), gettype($investigation_card_text)), __LINE__);
        }
        $this->investigation_card_text = $investigation_card_text;
        return $this;
    }
    /**
     * Get certification_code value
     * @return string|null
     */
    public function getCertification_code()
    {
        return $this->certification_code;
    }
    /**
     * Set certification_code value
     * @param string $certification_code
     * @return \StructType\Award
     */
    public function setCertification_code($certification_code = null)
    {
        // validation for constraint: string
        if (!is_null($certification_code) && !is_string($certification_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certification_code, true), gettype($certification_code)), __LINE__);
        }
        $this->certification_code = $certification_code;
        return $this;
    }
    /**
     * Get recert_by_award_code value
     * @return string|null
     */
    public function getRecert_by_award_code()
    {
        return $this->recert_by_award_code;
    }
    /**
     * Set recert_by_award_code value
     * @param string $recert_by_award_code
     * @return \StructType\Award
     */
    public function setRecert_by_award_code($recert_by_award_code = null)
    {
        // validation for constraint: string
        if (!is_null($recert_by_award_code) && !is_string($recert_by_award_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recert_by_award_code, true), gettype($recert_by_award_code)), __LINE__);
        }
        $this->recert_by_award_code = $recert_by_award_code;
        return $this;
    }
    /**
     * Get french_award_name value
     * @return string|null
     */
    public function getFrench_award_name()
    {
        return $this->french_award_name;
    }
    /**
     * Set french_award_name value
     * @param string $french_award_name
     * @return \StructType\Award
     */
    public function setFrench_award_name($french_award_name = null)
    {
        // validation for constraint: string
        if (!is_null($french_award_name) && !is_string($french_award_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($french_award_name, true), gettype($french_award_name)), __LINE__);
        }
        $this->french_award_name = $french_award_name;
        return $this;
    }
    /**
     * Get french_option_recert_text value
     * @return string|null
     */
    public function getFrench_option_recert_text()
    {
        return $this->french_option_recert_text;
    }
    /**
     * Set french_option_recert_text value
     * @param string $french_option_recert_text
     * @return \StructType\Award
     */
    public function setFrench_option_recert_text($french_option_recert_text = null)
    {
        // validation for constraint: string
        if (!is_null($french_option_recert_text) && !is_string($french_option_recert_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($french_option_recert_text, true), gettype($french_option_recert_text)), __LINE__);
        }
        $this->french_option_recert_text = $french_option_recert_text;
        return $this;
    }
    /**
     * Get french_award_card_text value
     * @return string|null
     */
    public function getFrench_award_card_text()
    {
        return $this->french_award_card_text;
    }
    /**
     * Set french_award_card_text value
     * @param string $french_award_card_text
     * @return \StructType\Award
     */
    public function setFrench_award_card_text($french_award_card_text = null)
    {
        // validation for constraint: string
        if (!is_null($french_award_card_text) && !is_string($french_award_card_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($french_award_card_text, true), gettype($french_award_card_text)), __LINE__);
        }
        $this->french_award_card_text = $french_award_card_text;
        return $this;
    }
    /**
     * Get french_investigation_card_text value
     * @return string|null
     */
    public function getFrench_investigation_card_text()
    {
        return $this->french_investigation_card_text;
    }
    /**
     * Set french_investigation_card_text value
     * @param string $french_investigation_card_text
     * @return \StructType\Award
     */
    public function setFrench_investigation_card_text($french_investigation_card_text = null)
    {
        // validation for constraint: string
        if (!is_null($french_investigation_card_text) && !is_string($french_investigation_card_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($french_investigation_card_text, true), gettype($french_investigation_card_text)), __LINE__);
        }
        $this->french_investigation_card_text = $french_investigation_card_text;
        return $this;
    }
    /**
     * Get award_stream_code value
     * @return string|null
     */
    public function getAward_stream_code()
    {
        return $this->award_stream_code;
    }
    /**
     * Set award_stream_code value
     * @param string $award_stream_code
     * @return \StructType\Award
     */
    public function setAward_stream_code($award_stream_code = null)
    {
        // validation for constraint: string
        if (!is_null($award_stream_code) && !is_string($award_stream_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($award_stream_code, true), gettype($award_stream_code)), __LINE__);
        }
        $this->award_stream_code = $award_stream_code;
        return $this;
    }
    /**
     * Get instructor_required_flag value
     * @return string|null
     */
    public function getInstructor_required_flag()
    {
        return $this->instructor_required_flag;
    }
    /**
     * Set instructor_required_flag value
     * @param string $instructor_required_flag
     * @return \StructType\Award
     */
    public function setInstructor_required_flag($instructor_required_flag = null)
    {
        // validation for constraint: string
        if (!is_null($instructor_required_flag) && !is_string($instructor_required_flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instructor_required_flag, true), gettype($instructor_required_flag)), __LINE__);
        }
        $this->instructor_required_flag = $instructor_required_flag;
        return $this;
    }
    /**
     * Get system_code_flag value
     * @return string|null
     */
    public function getSystem_code_flag()
    {
        return $this->system_code_flag;
    }
    /**
     * Set system_code_flag value
     * @param string $system_code_flag
     * @return \StructType\Award
     */
    public function setSystem_code_flag($system_code_flag = null)
    {
        // validation for constraint: string
        if (!is_null($system_code_flag) && !is_string($system_code_flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($system_code_flag, true), gettype($system_code_flag)), __LINE__);
        }
        $this->system_code_flag = $system_code_flag;
        return $this;
    }
    /**
     * Get national_award value
     * @return string|null
     */
    public function getNational_award()
    {
        return $this->national_award;
    }
    /**
     * Set national_award value
     * @param string $national_award
     * @return \StructType\Award
     */
    public function setNational_award($national_award = null)
    {
        // validation for constraint: string
        if (!is_null($national_award) && !is_string($national_award)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($national_award, true), gettype($national_award)), __LINE__);
        }
        $this->national_award = $national_award;
        return $this;
    }
}
