<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The address_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $address_id;
    /**
     * The member_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $member_id;
    /**
     * The okay_to_use_flag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $okay_to_use_flag;
    /**
     * The address_type_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address_type_code;
    /**
     * The address_type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address_type;
    /**
     * The primary_mailing_address_flag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primary_mailing_address_flag;
    /**
     * The line_1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $line_1;
    /**
     * The line_2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $line_2;
    /**
     * The line_3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $line_3;
    /**
     * The line_4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $line_4;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The province_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $province_code;
    /**
     * The province_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $province_name;
    /**
     * The postal_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postal_code;
    /**
     * The country_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country_code;
    /**
     * The country_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country_name;
    /**
     * The country_shows_in_address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country_shows_in_address;
    /**
     * Constructor method for address
     * @uses Address::setAddress_id()
     * @uses Address::setMember_id()
     * @uses Address::setOkay_to_use_flag()
     * @uses Address::setAddress_type_code()
     * @uses Address::setAddress_type()
     * @uses Address::setPrimary_mailing_address_flag()
     * @uses Address::setLine_1()
     * @uses Address::setLine_2()
     * @uses Address::setLine_3()
     * @uses Address::setLine_4()
     * @uses Address::setCity()
     * @uses Address::setProvince_code()
     * @uses Address::setProvince_name()
     * @uses Address::setPostal_code()
     * @uses Address::setCountry_code()
     * @uses Address::setCountry_name()
     * @uses Address::setCountry_shows_in_address()
     * @param int $address_id
     * @param string $member_id
     * @param string $okay_to_use_flag
     * @param string $address_type_code
     * @param string $address_type
     * @param string $primary_mailing_address_flag
     * @param string $line_1
     * @param string $line_2
     * @param string $line_3
     * @param string $line_4
     * @param string $city
     * @param string $province_code
     * @param string $province_name
     * @param string $postal_code
     * @param string $country_code
     * @param string $country_name
     * @param string $country_shows_in_address
     */
    public function __construct($address_id = null, $member_id = null, $okay_to_use_flag = null, $address_type_code = null, $address_type = null, $primary_mailing_address_flag = null, $line_1 = null, $line_2 = null, $line_3 = null, $line_4 = null, $city = null, $province_code = null, $province_name = null, $postal_code = null, $country_code = null, $country_name = null, $country_shows_in_address = null)
    {
        $this
            ->setAddress_id($address_id)
            ->setMember_id($member_id)
            ->setOkay_to_use_flag($okay_to_use_flag)
            ->setAddress_type_code($address_type_code)
            ->setAddress_type($address_type)
            ->setPrimary_mailing_address_flag($primary_mailing_address_flag)
            ->setLine_1($line_1)
            ->setLine_2($line_2)
            ->setLine_3($line_3)
            ->setLine_4($line_4)
            ->setCity($city)
            ->setProvince_code($province_code)
            ->setProvince_name($province_name)
            ->setPostal_code($postal_code)
            ->setCountry_code($country_code)
            ->setCountry_name($country_name)
            ->setCountry_shows_in_address($country_shows_in_address);
    }
    /**
     * Get address_id value
     * @return int
     */
    public function getAddress_id()
    {
        return $this->address_id;
    }
    /**
     * Set address_id value
     * @param int $address_id
     * @return \StructType\Address
     */
    public function setAddress_id($address_id = null)
    {
        // validation for constraint: int
        if (!is_null($address_id) && !(is_int($address_id) || ctype_digit($address_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($address_id, true), gettype($address_id)), __LINE__);
        }
        $this->address_id = $address_id;
        return $this;
    }
    /**
     * Get member_id value
     * @return string|null
     */
    public function getMember_id()
    {
        return $this->member_id;
    }
    /**
     * Set member_id value
     * @param string $member_id
     * @return \StructType\Address
     */
    public function setMember_id($member_id = null)
    {
        // validation for constraint: string
        if (!is_null($member_id) && !is_string($member_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($member_id, true), gettype($member_id)), __LINE__);
        }
        $this->member_id = $member_id;
        return $this;
    }
    /**
     * Get okay_to_use_flag value
     * @return string|null
     */
    public function getOkay_to_use_flag()
    {
        return $this->okay_to_use_flag;
    }
    /**
     * Set okay_to_use_flag value
     * @param string $okay_to_use_flag
     * @return \StructType\Address
     */
    public function setOkay_to_use_flag($okay_to_use_flag = null)
    {
        // validation for constraint: string
        if (!is_null($okay_to_use_flag) && !is_string($okay_to_use_flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($okay_to_use_flag, true), gettype($okay_to_use_flag)), __LINE__);
        }
        $this->okay_to_use_flag = $okay_to_use_flag;
        return $this;
    }
    /**
     * Get address_type_code value
     * @return string|null
     */
    public function getAddress_type_code()
    {
        return $this->address_type_code;
    }
    /**
     * Set address_type_code value
     * @param string $address_type_code
     * @return \StructType\Address
     */
    public function setAddress_type_code($address_type_code = null)
    {
        // validation for constraint: string
        if (!is_null($address_type_code) && !is_string($address_type_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address_type_code, true), gettype($address_type_code)), __LINE__);
        }
        $this->address_type_code = $address_type_code;
        return $this;
    }
    /**
     * Get address_type value
     * @return string|null
     */
    public function getAddress_type()
    {
        return $this->address_type;
    }
    /**
     * Set address_type value
     * @param string $address_type
     * @return \StructType\Address
     */
    public function setAddress_type($address_type = null)
    {
        // validation for constraint: string
        if (!is_null($address_type) && !is_string($address_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address_type, true), gettype($address_type)), __LINE__);
        }
        $this->address_type = $address_type;
        return $this;
    }
    /**
     * Get primary_mailing_address_flag value
     * @return string|null
     */
    public function getPrimary_mailing_address_flag()
    {
        return $this->primary_mailing_address_flag;
    }
    /**
     * Set primary_mailing_address_flag value
     * @param string $primary_mailing_address_flag
     * @return \StructType\Address
     */
    public function setPrimary_mailing_address_flag($primary_mailing_address_flag = null)
    {
        // validation for constraint: string
        if (!is_null($primary_mailing_address_flag) && !is_string($primary_mailing_address_flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primary_mailing_address_flag, true), gettype($primary_mailing_address_flag)), __LINE__);
        }
        $this->primary_mailing_address_flag = $primary_mailing_address_flag;
        return $this;
    }
    /**
     * Get line value
     * @return line
     */
    public function getLine_1()
    {
        return $this->line_1;
    }
    /**
     * Set line value
     * @param line $line
     * @return \StructType\Address
     */
    public function setLine_1($line_1 = null)
    {
        // validation for constraint: string
        if (!is_null($line_1) && !is_string($line_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_1, true), gettype($line_1)), __LINE__);
        }
        $this->line_1 = $line_1;
        return $this;
    }
    /**
     * Get line value
     * @return line
     */
    public function getLine_2()
    {
        return $this->line_2;
    }
    /**
     * Set line value
     * @param line $line
     * @return \StructType\Address
     */
    public function setLine_2($line_2 = null)
    {
        // validation for constraint: string
        if (!is_null($line_2) && !is_string($line_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_2, true), gettype($line_2)), __LINE__);
        }
        $this->line_2 = $line_2;
        return $this;
    }
    /**
     * Get line value
     * @return line
     */
    public function getLine_3()
    {
        return $this->line_3;
    }
    /**
     * Set line value
     * @param line $line
     * @return \StructType\Address
     */
    public function setLine_3($line_3 = null)
    {
        // validation for constraint: string
        if (!is_null($line_3) && !is_string($line_3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_3, true), gettype($line_3)), __LINE__);
        }
        $this->line_3 = $line_3;
        return $this;
    }
    /**
     * Get line value
     * @return line
     */
    public function getLine_4()
    {
        return $this->line_4;
    }
    /**
     * Set line value
     * @param line $line
     * @return \StructType\Address
     */
    public function setLine_4($line_4 = null)
    {
        // validation for constraint: string
        if (!is_null($line_4) && !is_string($line_4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_4, true), gettype($line_4)), __LINE__);
        }
        $this->line_4 = $line_4;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get province_code value
     * @return string|null
     */
    public function getProvince_code()
    {
        return $this->province_code;
    }
    /**
     * Set province_code value
     * @param string $province_code
     * @return \StructType\Address
     */
    public function setProvince_code($province_code = null)
    {
        // validation for constraint: string
        if (!is_null($province_code) && !is_string($province_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($province_code, true), gettype($province_code)), __LINE__);
        }
        $this->province_code = $province_code;
        return $this;
    }
    /**
     * Get province_name value
     * @return string|null
     */
    public function getProvince_name()
    {
        return $this->province_name;
    }
    /**
     * Set province_name value
     * @param string $province_name
     * @return \StructType\Address
     */
    public function setProvince_name($province_name = null)
    {
        // validation for constraint: string
        if (!is_null($province_name) && !is_string($province_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($province_name, true), gettype($province_name)), __LINE__);
        }
        $this->province_name = $province_name;
        return $this;
    }
    /**
     * Get postal_code value
     * @return string|null
     */
    public function getPostal_code()
    {
        return $this->postal_code;
    }
    /**
     * Set postal_code value
     * @param string $postal_code
     * @return \StructType\Address
     */
    public function setPostal_code($postal_code = null)
    {
        // validation for constraint: string
        if (!is_null($postal_code) && !is_string($postal_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postal_code, true), gettype($postal_code)), __LINE__);
        }
        $this->postal_code = $postal_code;
        return $this;
    }
    /**
     * Get country_code value
     * @return string|null
     */
    public function getCountry_code()
    {
        return $this->country_code;
    }
    /**
     * Set country_code value
     * @param string $country_code
     * @return \StructType\Address
     */
    public function setCountry_code($country_code = null)
    {
        // validation for constraint: string
        if (!is_null($country_code) && !is_string($country_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_code, true), gettype($country_code)), __LINE__);
        }
        $this->country_code = $country_code;
        return $this;
    }
    /**
     * Get country_name value
     * @return string|null
     */
    public function getCountry_name()
    {
        return $this->country_name;
    }
    /**
     * Set country_name value
     * @param string $country_name
     * @return \StructType\Address
     */
    public function setCountry_name($country_name = null)
    {
        // validation for constraint: string
        if (!is_null($country_name) && !is_string($country_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_name, true), gettype($country_name)), __LINE__);
        }
        $this->country_name = $country_name;
        return $this;
    }
    /**
     * Get country_shows_in_address value
     * @return string|null
     */
    public function getCountry_shows_in_address()
    {
        return $this->country_shows_in_address;
    }
    /**
     * Set country_shows_in_address value
     * @param string $country_shows_in_address
     * @return \StructType\Address
     */
    public function setCountry_shows_in_address($country_shows_in_address = null)
    {
        // validation for constraint: string
        if (!is_null($country_shows_in_address) && !is_string($country_shows_in_address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_shows_in_address, true), gettype($country_shows_in_address)), __LINE__);
        }
        $this->country_shows_in_address = $country_shows_in_address;
        return $this;
    }
}
