<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Courseeligibility ServiceType
 * @subpackage Services
 */
class Courseeligibility extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named course_eligibility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Course_eligibility $parameters
     * @return \StructType\Course_eligibilityResponse|bool
     */
    public function course_eligibility(\StructType\Course_eligibility $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->course_eligibility($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Course_eligibilityResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
