<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Findmember ServiceType
 * @subpackage Services
 */
class Findmember extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named find_member
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Find_member $parameters
     * @return \StructType\Find_memberResponse|bool
     */
    public function find_member(\StructType\Find_member $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->find_member($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Find_memberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
