<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Recordonlinecourseresult ServiceType
 */
$recordonlinecourseresult = new \ServiceType\Recordonlinecourseresult($options);
/**
 * Sample call for record_online_course_result operation/method
 */
if ($recordonlinecourseresult->record_online_course_result(new \StructType\Record_online_course_result()) !== false) {
    print_r($recordonlinecourseresult->getResult());
} else {
    print_r($recordonlinecourseresult->getLastError());
}
/**
 * Samples for Findmember ServiceType
 */
$findmember = new \ServiceType\Findmember($options);
/**
 * Sample call for find_member operation/method
 */
if ($findmember->find_member(new \StructType\Find_member()) !== false) {
    print_r($findmember->getResult());
} else {
    print_r($findmember->getLastError());
}
/**
 * Samples for Courseeligibility ServiceType
 */
$courseeligibility = new \ServiceType\Courseeligibility($options);
/**
 * Sample call for course_eligibility operation/method
 */
if ($courseeligibility->course_eligibility(new \StructType\Course_eligibility()) !== false) {
    print_r($courseeligibility->getResult());
} else {
    print_r($courseeligibility->getLastError());
}
/**
 * Samples for Updatememberid ServiceType
 */
$updatememberid = new \ServiceType\Updatememberid($options);
/**
 * Sample call for update_member_id operation/method
 */
if ($updatememberid->update_member_id(new \StructType\Update_member_id()) !== false) {
    print_r($updatememberid->getResult());
} else {
    print_r($updatememberid->getLastError());
}
