<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for record_online_course_result StructType
 * @subpackage Structs
 */
class Record_online_course_result extends AbstractStructBase
{
    /**
     * The online_user_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $online_user_id;
    /**
     * The authtoken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authtoken;
    /**
     * The partial_or_complete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partial_or_complete;
    /**
     * The award_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $award_code;
    /**
     * The pass_or_fail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pass_or_fail;
    /**
     * The organized_by_customer_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $organized_by_customer_code;
    /**
     * The emails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEmail
     */
    public $emails;
    /**
     * The addresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAddress
     */
    public $addresses;
    /**
     * The phones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPhone
     */
    public $phones;
    /**
     * The individual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Individual
     */
    public $individual;
    /**
     * Constructor method for record_online_course_result
     * @uses Record_online_course_result::setOnline_user_id()
     * @uses Record_online_course_result::setAuthtoken()
     * @uses Record_online_course_result::setPartial_or_complete()
     * @uses Record_online_course_result::setAward_code()
     * @uses Record_online_course_result::setPass_or_fail()
     * @uses Record_online_course_result::setOrganized_by_customer_code()
     * @uses Record_online_course_result::setEmails()
     * @uses Record_online_course_result::setAddresses()
     * @uses Record_online_course_result::setPhones()
     * @uses Record_online_course_result::setIndividual()
     * @param int $online_user_id
     * @param string $authtoken
     * @param string $partial_or_complete
     * @param string $award_code
     * @param string $pass_or_fail
     * @param string $organized_by_customer_code
     * @param \ArrayType\ArrayOfEmail $emails
     * @param \ArrayType\ArrayOfAddress $addresses
     * @param \ArrayType\ArrayOfPhone $phones
     * @param \StructType\Individual $individual
     */
    public function __construct($online_user_id = null, $authtoken = null, $partial_or_complete = null, $award_code = null, $pass_or_fail = null, $organized_by_customer_code = null, \ArrayType\ArrayOfEmail $emails = null, \ArrayType\ArrayOfAddress $addresses = null, \ArrayType\ArrayOfPhone $phones = null, \StructType\Individual $individual = null)
    {
        $this
            ->setOnline_user_id($online_user_id)
            ->setAuthtoken($authtoken)
            ->setPartial_or_complete($partial_or_complete)
            ->setAward_code($award_code)
            ->setPass_or_fail($pass_or_fail)
            ->setOrganized_by_customer_code($organized_by_customer_code)
            ->setEmails($emails)
            ->setAddresses($addresses)
            ->setPhones($phones)
            ->setIndividual($individual);
    }
    /**
     * Get online_user_id value
     * @return int
     */
    public function getOnline_user_id()
    {
        return $this->online_user_id;
    }
    /**
     * Set online_user_id value
     * @param int $online_user_id
     * @return \StructType\Record_online_course_result
     */
    public function setOnline_user_id($online_user_id = null)
    {
        // validation for constraint: int
        if (!is_null($online_user_id) && !(is_int($online_user_id) || ctype_digit($online_user_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($online_user_id, true), gettype($online_user_id)), __LINE__);
        }
        $this->online_user_id = $online_user_id;
        return $this;
    }
    /**
     * Get authtoken value
     * @return string|null
     */
    public function getAuthtoken()
    {
        return $this->authtoken;
    }
    /**
     * Set authtoken value
     * @param string $authtoken
     * @return \StructType\Record_online_course_result
     */
    public function setAuthtoken($authtoken = null)
    {
        // validation for constraint: string
        if (!is_null($authtoken) && !is_string($authtoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authtoken, true), gettype($authtoken)), __LINE__);
        }
        $this->authtoken = $authtoken;
        return $this;
    }
    /**
     * Get partial_or_complete value
     * @return string|null
     */
    public function getPartial_or_complete()
    {
        return $this->partial_or_complete;
    }
    /**
     * Set partial_or_complete value
     * @param string $partial_or_complete
     * @return \StructType\Record_online_course_result
     */
    public function setPartial_or_complete($partial_or_complete = null)
    {
        // validation for constraint: string
        if (!is_null($partial_or_complete) && !is_string($partial_or_complete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partial_or_complete, true), gettype($partial_or_complete)), __LINE__);
        }
        $this->partial_or_complete = $partial_or_complete;
        return $this;
    }
    /**
     * Get award_code value
     * @return string|null
     */
    public function getAward_code()
    {
        return $this->award_code;
    }
    /**
     * Set award_code value
     * @param string $award_code
     * @return \StructType\Record_online_course_result
     */
    public function setAward_code($award_code = null)
    {
        // validation for constraint: string
        if (!is_null($award_code) && !is_string($award_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($award_code, true), gettype($award_code)), __LINE__);
        }
        $this->award_code = $award_code;
        return $this;
    }
    /**
     * Get pass_or_fail value
     * @return string|null
     */
    public function getPass_or_fail()
    {
        return $this->pass_or_fail;
    }
    /**
     * Set pass_or_fail value
     * @param string $pass_or_fail
     * @return \StructType\Record_online_course_result
     */
    public function setPass_or_fail($pass_or_fail = null)
    {
        // validation for constraint: string
        if (!is_null($pass_or_fail) && !is_string($pass_or_fail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pass_or_fail, true), gettype($pass_or_fail)), __LINE__);
        }
        $this->pass_or_fail = $pass_or_fail;
        return $this;
    }
    /**
     * Get organized_by_customer_code value
     * @return string|null
     */
    public function getOrganized_by_customer_code()
    {
        return $this->organized_by_customer_code;
    }
    /**
     * Set organized_by_customer_code value
     * @param string $organized_by_customer_code
     * @return \StructType\Record_online_course_result
     */
    public function setOrganized_by_customer_code($organized_by_customer_code = null)
    {
        // validation for constraint: string
        if (!is_null($organized_by_customer_code) && !is_string($organized_by_customer_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organized_by_customer_code, true), gettype($organized_by_customer_code)), __LINE__);
        }
        $this->organized_by_customer_code = $organized_by_customer_code;
        return $this;
    }
    /**
     * Get emails value
     * @return \ArrayType\ArrayOfEmail|null
     */
    public function getEmails()
    {
        return $this->emails;
    }
    /**
     * Set emails value
     * @param \ArrayType\ArrayOfEmail $emails
     * @return \StructType\Record_online_course_result
     */
    public function setEmails(\ArrayType\ArrayOfEmail $emails = null)
    {
        $this->emails = $emails;
        return $this;
    }
    /**
     * Get addresses value
     * @return \ArrayType\ArrayOfAddress|null
     */
    public function getAddresses()
    {
        return $this->addresses;
    }
    /**
     * Set addresses value
     * @param \ArrayType\ArrayOfAddress $addresses
     * @return \StructType\Record_online_course_result
     */
    public function setAddresses(\ArrayType\ArrayOfAddress $addresses = null)
    {
        $this->addresses = $addresses;
        return $this;
    }
    /**
     * Get phones value
     * @return \ArrayType\ArrayOfPhone|null
     */
    public function getPhones()
    {
        return $this->phones;
    }
    /**
     * Set phones value
     * @param \ArrayType\ArrayOfPhone $phones
     * @return \StructType\Record_online_course_result
     */
    public function setPhones(\ArrayType\ArrayOfPhone $phones = null)
    {
        $this->phones = $phones;
        return $this;
    }
    /**
     * Get individual value
     * @return \StructType\Individual|null
     */
    public function getIndividual()
    {
        return $this->individual;
    }
    /**
     * Set individual value
     * @param \StructType\Individual $individual
     * @return \StructType\Record_online_course_result
     */
    public function setIndividual(\StructType\Individual $individual = null)
    {
        $this->individual = $individual;
        return $this;
    }
}
