<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for individual StructType
 * @subpackage Structs
 */
class Individual extends AbstractStructBase
{
    /**
     * The mailing_address_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mailing_address_id;
    /**
     * The primary_email_address_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $primary_email_address_id;
    /**
     * The primary_phone_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $primary_phone_id;
    /**
     * The birth_date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $birth_date;
    /**
     * The member_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $member_id;
    /**
     * The first_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $first_name;
    /**
     * The middle_initial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middle_initial;
    /**
     * The last_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $last_name;
    /**
     * The aka
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aka;
    /**
     * The contact_info
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Contact_info
     */
    public $contact_info;
    /**
     * The approval_status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $approval_status;
    /**
     * The dummy_can_be_deleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dummy_can_be_deleted;
    /**
     * The sex_type_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sex_type_code;
    /**
     * Constructor method for individual
     * @uses Individual::setMailing_address_id()
     * @uses Individual::setPrimary_email_address_id()
     * @uses Individual::setPrimary_phone_id()
     * @uses Individual::setBirth_date()
     * @uses Individual::setMember_id()
     * @uses Individual::setFirst_name()
     * @uses Individual::setMiddle_initial()
     * @uses Individual::setLast_name()
     * @uses Individual::setAka()
     * @uses Individual::setContact_info()
     * @uses Individual::setApproval_status()
     * @uses Individual::setDummy_can_be_deleted()
     * @uses Individual::setSex_type_code()
     * @param int $mailing_address_id
     * @param int $primary_email_address_id
     * @param int $primary_phone_id
     * @param string $birth_date
     * @param string $member_id
     * @param string $first_name
     * @param string $middle_initial
     * @param string $last_name
     * @param string $aka
     * @param \StructType\Contact_info $contact_info
     * @param string $approval_status
     * @param string $dummy_can_be_deleted
     * @param string $sex_type_code
     */
    public function __construct($mailing_address_id = null, $primary_email_address_id = null, $primary_phone_id = null, $birth_date = null, $member_id = null, $first_name = null, $middle_initial = null, $last_name = null, $aka = null, \StructType\Contact_info $contact_info = null, $approval_status = null, $dummy_can_be_deleted = null, $sex_type_code = null)
    {
        $this
            ->setMailing_address_id($mailing_address_id)
            ->setPrimary_email_address_id($primary_email_address_id)
            ->setPrimary_phone_id($primary_phone_id)
            ->setBirth_date($birth_date)
            ->setMember_id($member_id)
            ->setFirst_name($first_name)
            ->setMiddle_initial($middle_initial)
            ->setLast_name($last_name)
            ->setAka($aka)
            ->setContact_info($contact_info)
            ->setApproval_status($approval_status)
            ->setDummy_can_be_deleted($dummy_can_be_deleted)
            ->setSex_type_code($sex_type_code);
    }
    /**
     * Get mailing_address_id value
     * @return int
     */
    public function getMailing_address_id()
    {
        return $this->mailing_address_id;
    }
    /**
     * Set mailing_address_id value
     * @param int $mailing_address_id
     * @return \StructType\Individual
     */
    public function setMailing_address_id($mailing_address_id = null)
    {
        // validation for constraint: int
        if (!is_null($mailing_address_id) && !(is_int($mailing_address_id) || ctype_digit($mailing_address_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailing_address_id, true), gettype($mailing_address_id)), __LINE__);
        }
        $this->mailing_address_id = $mailing_address_id;
        return $this;
    }
    /**
     * Get primary_email_address_id value
     * @return int
     */
    public function getPrimary_email_address_id()
    {
        return $this->primary_email_address_id;
    }
    /**
     * Set primary_email_address_id value
     * @param int $primary_email_address_id
     * @return \StructType\Individual
     */
    public function setPrimary_email_address_id($primary_email_address_id = null)
    {
        // validation for constraint: int
        if (!is_null($primary_email_address_id) && !(is_int($primary_email_address_id) || ctype_digit($primary_email_address_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($primary_email_address_id, true), gettype($primary_email_address_id)), __LINE__);
        }
        $this->primary_email_address_id = $primary_email_address_id;
        return $this;
    }
    /**
     * Get primary_phone_id value
     * @return int
     */
    public function getPrimary_phone_id()
    {
        return $this->primary_phone_id;
    }
    /**
     * Set primary_phone_id value
     * @param int $primary_phone_id
     * @return \StructType\Individual
     */
    public function setPrimary_phone_id($primary_phone_id = null)
    {
        // validation for constraint: int
        if (!is_null($primary_phone_id) && !(is_int($primary_phone_id) || ctype_digit($primary_phone_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($primary_phone_id, true), gettype($primary_phone_id)), __LINE__);
        }
        $this->primary_phone_id = $primary_phone_id;
        return $this;
    }
    /**
     * Get birth_date value
     * @return string
     */
    public function getBirth_date()
    {
        return $this->birth_date;
    }
    /**
     * Set birth_date value
     * @param string $birth_date
     * @return \StructType\Individual
     */
    public function setBirth_date($birth_date = null)
    {
        // validation for constraint: string
        if (!is_null($birth_date) && !is_string($birth_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birth_date, true), gettype($birth_date)), __LINE__);
        }
        $this->birth_date = $birth_date;
        return $this;
    }
    /**
     * Get member_id value
     * @return string|null
     */
    public function getMember_id()
    {
        return $this->member_id;
    }
    /**
     * Set member_id value
     * @param string $member_id
     * @return \StructType\Individual
     */
    public function setMember_id($member_id = null)
    {
        // validation for constraint: string
        if (!is_null($member_id) && !is_string($member_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($member_id, true), gettype($member_id)), __LINE__);
        }
        $this->member_id = $member_id;
        return $this;
    }
    /**
     * Get first_name value
     * @return string|null
     */
    public function getFirst_name()
    {
        return $this->first_name;
    }
    /**
     * Set first_name value
     * @param string $first_name
     * @return \StructType\Individual
     */
    public function setFirst_name($first_name = null)
    {
        // validation for constraint: string
        if (!is_null($first_name) && !is_string($first_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first_name, true), gettype($first_name)), __LINE__);
        }
        $this->first_name = $first_name;
        return $this;
    }
    /**
     * Get middle_initial value
     * @return string|null
     */
    public function getMiddle_initial()
    {
        return $this->middle_initial;
    }
    /**
     * Set middle_initial value
     * @param string $middle_initial
     * @return \StructType\Individual
     */
    public function setMiddle_initial($middle_initial = null)
    {
        // validation for constraint: string
        if (!is_null($middle_initial) && !is_string($middle_initial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middle_initial, true), gettype($middle_initial)), __LINE__);
        }
        $this->middle_initial = $middle_initial;
        return $this;
    }
    /**
     * Get last_name value
     * @return string|null
     */
    public function getLast_name()
    {
        return $this->last_name;
    }
    /**
     * Set last_name value
     * @param string $last_name
     * @return \StructType\Individual
     */
    public function setLast_name($last_name = null)
    {
        // validation for constraint: string
        if (!is_null($last_name) && !is_string($last_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_name, true), gettype($last_name)), __LINE__);
        }
        $this->last_name = $last_name;
        return $this;
    }
    /**
     * Get aka value
     * @return string|null
     */
    public function getAka()
    {
        return $this->aka;
    }
    /**
     * Set aka value
     * @param string $aka
     * @return \StructType\Individual
     */
    public function setAka($aka = null)
    {
        // validation for constraint: string
        if (!is_null($aka) && !is_string($aka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aka, true), gettype($aka)), __LINE__);
        }
        $this->aka = $aka;
        return $this;
    }
    /**
     * Get contact_info value
     * @return \StructType\Contact_info|null
     */
    public function getContact_info()
    {
        return $this->contact_info;
    }
    /**
     * Set contact_info value
     * @param \StructType\Contact_info $contact_info
     * @return \StructType\Individual
     */
    public function setContact_info(\StructType\Contact_info $contact_info = null)
    {
        $this->contact_info = $contact_info;
        return $this;
    }
    /**
     * Get approval_status value
     * @return string|null
     */
    public function getApproval_status()
    {
        return $this->approval_status;
    }
    /**
     * Set approval_status value
     * @param string $approval_status
     * @return \StructType\Individual
     */
    public function setApproval_status($approval_status = null)
    {
        // validation for constraint: string
        if (!is_null($approval_status) && !is_string($approval_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approval_status, true), gettype($approval_status)), __LINE__);
        }
        $this->approval_status = $approval_status;
        return $this;
    }
    /**
     * Get dummy_can_be_deleted value
     * @return string|null
     */
    public function getDummy_can_be_deleted()
    {
        return $this->dummy_can_be_deleted;
    }
    /**
     * Set dummy_can_be_deleted value
     * @param string $dummy_can_be_deleted
     * @return \StructType\Individual
     */
    public function setDummy_can_be_deleted($dummy_can_be_deleted = null)
    {
        // validation for constraint: string
        if (!is_null($dummy_can_be_deleted) && !is_string($dummy_can_be_deleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dummy_can_be_deleted, true), gettype($dummy_can_be_deleted)), __LINE__);
        }
        $this->dummy_can_be_deleted = $dummy_can_be_deleted;
        return $this;
    }
    /**
     * Get sex_type_code value
     * @return string|null
     */
    public function getSex_type_code()
    {
        return $this->sex_type_code;
    }
    /**
     * Set sex_type_code value
     * @param string $sex_type_code
     * @return \StructType\Individual
     */
    public function setSex_type_code($sex_type_code = null)
    {
        // validation for constraint: string
        if (!is_null($sex_type_code) && !is_string($sex_type_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sex_type_code, true), gettype($sex_type_code)), __LINE__);
        }
        $this->sex_type_code = $sex_type_code;
        return $this;
    }
}
