<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for email StructType
 * @subpackage Structs
 */
class Email extends AbstractStructBase
{
    /**
     * The email_address_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $email_address_id;
    /**
     * The member_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $member_id;
    /**
     * The okay_to_use_flag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $okay_to_use_flag;
    /**
     * The email_address_type_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email_address_type_code;
    /**
     * The email_address_type_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email_address_type_name;
    /**
     * The primary_email_flag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primary_email_flag;
    /**
     * The email_address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email_address;
    /**
     * Constructor method for email
     * @uses Email::setEmail_address_id()
     * @uses Email::setMember_id()
     * @uses Email::setOkay_to_use_flag()
     * @uses Email::setEmail_address_type_code()
     * @uses Email::setEmail_address_type_name()
     * @uses Email::setPrimary_email_flag()
     * @uses Email::setEmail_address()
     * @param int $email_address_id
     * @param string $member_id
     * @param string $okay_to_use_flag
     * @param string $email_address_type_code
     * @param string $email_address_type_name
     * @param string $primary_email_flag
     * @param string $email_address
     */
    public function __construct($email_address_id = null, $member_id = null, $okay_to_use_flag = null, $email_address_type_code = null, $email_address_type_name = null, $primary_email_flag = null, $email_address = null)
    {
        $this
            ->setEmail_address_id($email_address_id)
            ->setMember_id($member_id)
            ->setOkay_to_use_flag($okay_to_use_flag)
            ->setEmail_address_type_code($email_address_type_code)
            ->setEmail_address_type_name($email_address_type_name)
            ->setPrimary_email_flag($primary_email_flag)
            ->setEmail_address($email_address);
    }
    /**
     * Get email_address_id value
     * @return int
     */
    public function getEmail_address_id()
    {
        return $this->email_address_id;
    }
    /**
     * Set email_address_id value
     * @param int $email_address_id
     * @return \StructType\Email
     */
    public function setEmail_address_id($email_address_id = null)
    {
        // validation for constraint: int
        if (!is_null($email_address_id) && !(is_int($email_address_id) || ctype_digit($email_address_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($email_address_id, true), gettype($email_address_id)), __LINE__);
        }
        $this->email_address_id = $email_address_id;
        return $this;
    }
    /**
     * Get member_id value
     * @return string|null
     */
    public function getMember_id()
    {
        return $this->member_id;
    }
    /**
     * Set member_id value
     * @param string $member_id
     * @return \StructType\Email
     */
    public function setMember_id($member_id = null)
    {
        // validation for constraint: string
        if (!is_null($member_id) && !is_string($member_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($member_id, true), gettype($member_id)), __LINE__);
        }
        $this->member_id = $member_id;
        return $this;
    }
    /**
     * Get okay_to_use_flag value
     * @return string|null
     */
    public function getOkay_to_use_flag()
    {
        return $this->okay_to_use_flag;
    }
    /**
     * Set okay_to_use_flag value
     * @param string $okay_to_use_flag
     * @return \StructType\Email
     */
    public function setOkay_to_use_flag($okay_to_use_flag = null)
    {
        // validation for constraint: string
        if (!is_null($okay_to_use_flag) && !is_string($okay_to_use_flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($okay_to_use_flag, true), gettype($okay_to_use_flag)), __LINE__);
        }
        $this->okay_to_use_flag = $okay_to_use_flag;
        return $this;
    }
    /**
     * Get email_address_type_code value
     * @return string|null
     */
    public function getEmail_address_type_code()
    {
        return $this->email_address_type_code;
    }
    /**
     * Set email_address_type_code value
     * @param string $email_address_type_code
     * @return \StructType\Email
     */
    public function setEmail_address_type_code($email_address_type_code = null)
    {
        // validation for constraint: string
        if (!is_null($email_address_type_code) && !is_string($email_address_type_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_address_type_code, true), gettype($email_address_type_code)), __LINE__);
        }
        $this->email_address_type_code = $email_address_type_code;
        return $this;
    }
    /**
     * Get email_address_type_name value
     * @return string|null
     */
    public function getEmail_address_type_name()
    {
        return $this->email_address_type_name;
    }
    /**
     * Set email_address_type_name value
     * @param string $email_address_type_name
     * @return \StructType\Email
     */
    public function setEmail_address_type_name($email_address_type_name = null)
    {
        // validation for constraint: string
        if (!is_null($email_address_type_name) && !is_string($email_address_type_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_address_type_name, true), gettype($email_address_type_name)), __LINE__);
        }
        $this->email_address_type_name = $email_address_type_name;
        return $this;
    }
    /**
     * Get primary_email_flag value
     * @return string|null
     */
    public function getPrimary_email_flag()
    {
        return $this->primary_email_flag;
    }
    /**
     * Set primary_email_flag value
     * @param string $primary_email_flag
     * @return \StructType\Email
     */
    public function setPrimary_email_flag($primary_email_flag = null)
    {
        // validation for constraint: string
        if (!is_null($primary_email_flag) && !is_string($primary_email_flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primary_email_flag, true), gettype($primary_email_flag)), __LINE__);
        }
        $this->primary_email_flag = $primary_email_flag;
        return $this;
    }
    /**
     * Get email_address value
     * @return string|null
     */
    public function getEmail_address()
    {
        return $this->email_address;
    }
    /**
     * Set email_address value
     * @param string $email_address
     * @return \StructType\Email
     */
    public function setEmail_address($email_address = null)
    {
        // validation for constraint: string
        if (!is_null($email_address) && !is_string($email_address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_address, true), gettype($email_address)), __LINE__);
        }
        $this->email_address = $email_address;
        return $this;
    }
}
