<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for course_eligibility StructType
 * @subpackage Structs
 */
class Course_eligibility extends AbstractStructBase
{
    /**
     * The authtoken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authtoken;
    /**
     * The customer_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customer_code;
    /**
     * The awards_to_check
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $awards_to_check;
    /**
     * Constructor method for course_eligibility
     * @uses Course_eligibility::setAuthtoken()
     * @uses Course_eligibility::setCustomer_code()
     * @uses Course_eligibility::setAwards_to_check()
     * @param string $authtoken
     * @param string $customer_code
     * @param \ArrayType\ArrayOfString $awards_to_check
     */
    public function __construct($authtoken = null, $customer_code = null, \ArrayType\ArrayOfString $awards_to_check = null)
    {
        $this
            ->setAuthtoken($authtoken)
            ->setCustomer_code($customer_code)
            ->setAwards_to_check($awards_to_check);
    }
    /**
     * Get authtoken value
     * @return string|null
     */
    public function getAuthtoken()
    {
        return $this->authtoken;
    }
    /**
     * Set authtoken value
     * @param string $authtoken
     * @return \StructType\Course_eligibility
     */
    public function setAuthtoken($authtoken = null)
    {
        // validation for constraint: string
        if (!is_null($authtoken) && !is_string($authtoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authtoken, true), gettype($authtoken)), __LINE__);
        }
        $this->authtoken = $authtoken;
        return $this;
    }
    /**
     * Get customer_code value
     * @return string|null
     */
    public function getCustomer_code()
    {
        return $this->customer_code;
    }
    /**
     * Set customer_code value
     * @param string $customer_code
     * @return \StructType\Course_eligibility
     */
    public function setCustomer_code($customer_code = null)
    {
        // validation for constraint: string
        if (!is_null($customer_code) && !is_string($customer_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_code, true), gettype($customer_code)), __LINE__);
        }
        $this->customer_code = $customer_code;
        return $this;
    }
    /**
     * Get awards_to_check value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAwards_to_check()
    {
        return $this->awards_to_check;
    }
    /**
     * Set awards_to_check value
     * @param \ArrayType\ArrayOfString $awards_to_check
     * @return \StructType\Course_eligibility
     */
    public function setAwards_to_check(\ArrayType\ArrayOfString $awards_to_check = null)
    {
        $this->awards_to_check = $awards_to_check;
        return $this;
    }
}
