<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAward ArrayType
 * @subpackage Arrays
 */
class ArrayOfAward extends AbstractStructArrayBase
{
    /**
     * The award
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Award[]
     */
    public $award;
    /**
     * Constructor method for ArrayOfAward
     * @uses ArrayOfAward::setAward()
     * @param \StructType\Award[] $award
     */
    public function __construct(array $award = array())
    {
        $this
            ->setAward($award);
    }
    /**
     * Get award value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Award[]|null
     */
    public function getAward()
    {
        return isset($this->award) ? $this->award : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAward method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAward method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAwardForArrayConstraintsFromSetAward(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAwardAwardItem) {
            // validation for constraint: itemType
            if (!$arrayOfAwardAwardItem instanceof \StructType\Award) {
                $invalidValues[] = is_object($arrayOfAwardAwardItem) ? get_class($arrayOfAwardAwardItem) : sprintf('%s(%s)', gettype($arrayOfAwardAwardItem), var_export($arrayOfAwardAwardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The award property can only contain items of type \StructType\Award, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set award value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Award[] $award
     * @return \ArrayType\ArrayOfAward
     */
    public function setAward(array $award = array())
    {
        // validation for constraint: array
        if ('' !== ($awardArrayErrorMessage = self::validateAwardForArrayConstraintsFromSetAward($award))) {
            throw new \InvalidArgumentException($awardArrayErrorMessage, __LINE__);
        }
        if (is_null($award) || (is_array($award) && empty($award))) {
            unset($this->award);
        } else {
            $this->award = $award;
        }
        return $this;
    }
    /**
     * Add item to award value
     * @throws \InvalidArgumentException
     * @param \StructType\Award $item
     * @return \ArrayType\ArrayOfAward
     */
    public function addToAward(\StructType\Award $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Award) {
            throw new \InvalidArgumentException(sprintf('The award property can only contain items of type \StructType\Award, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->award[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Award|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Award|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Award|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Award|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Award|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string award
     */
    public function getAttributeName()
    {
        return 'award';
    }
}
