<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Load StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Load
 * @subpackage Structs
 */
class Load extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Unit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Unit;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * Constructor method for Load
     * @uses Load::setType()
     * @uses Load::setUnit()
     * @uses Load::setValue()
     * @param string $type
     * @param string $unit
     * @param float $value
     */
    public function __construct($type = null, $unit = null, $value = null)
    {
        $this
            ->setType($type)
            ->setUnit($unit)
            ->setValue($value);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\LoadType::valueIsValid()
     * @uses \EnumType\LoadType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Load
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LoadType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\LoadType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @uses \EnumType\LoadUnit::valueIsValid()
     * @uses \EnumType\LoadUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit
     * @return \StructType\Load
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LoadUnit::valueIsValid($unit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unit, implode(', ', \EnumType\LoadUnit::getValidValues())), __LINE__);
        }
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\Load
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Load
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
