<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightTouched StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightTouched
 * @subpackage Structs
 */
class FlightTouched extends AbstractStructBase
{
    /**
     * The AircraftRegistration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftRegistration;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirport;
    /**
     * The CommercialFlightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommercialFlightNumber;
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirport;
    /**
     * The ExternalFlightId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalFlightId;
    /**
     * The IcaoFlightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IcaoFlightNumber;
    /**
     * The ScheduledTimeOfDeparture
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledTimeOfDeparture;
    /**
     * Constructor method for FlightTouched
     * @uses FlightTouched::setAircraftRegistration()
     * @uses FlightTouched::setArrivalAirport()
     * @uses FlightTouched::setCommercialFlightNumber()
     * @uses FlightTouched::setDepartureAirport()
     * @uses FlightTouched::setExternalFlightId()
     * @uses FlightTouched::setIcaoFlightNumber()
     * @uses FlightTouched::setScheduledTimeOfDeparture()
     * @param string $aircraftRegistration
     * @param string $arrivalAirport
     * @param string $commercialFlightNumber
     * @param string $departureAirport
     * @param string $externalFlightId
     * @param string $icaoFlightNumber
     * @param string $scheduledTimeOfDeparture
     */
    public function __construct($aircraftRegistration = null, $arrivalAirport = null, $commercialFlightNumber = null, $departureAirport = null, $externalFlightId = null, $icaoFlightNumber = null, $scheduledTimeOfDeparture = null)
    {
        $this
            ->setAircraftRegistration($aircraftRegistration)
            ->setArrivalAirport($arrivalAirport)
            ->setCommercialFlightNumber($commercialFlightNumber)
            ->setDepartureAirport($departureAirport)
            ->setExternalFlightId($externalFlightId)
            ->setIcaoFlightNumber($icaoFlightNumber)
            ->setScheduledTimeOfDeparture($scheduledTimeOfDeparture);
    }
    /**
     * Get AircraftRegistration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftRegistration()
    {
        return isset($this->AircraftRegistration) ? $this->AircraftRegistration : null;
    }
    /**
     * Set AircraftRegistration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftRegistration
     * @return \StructType\FlightTouched
     */
    public function setAircraftRegistration($aircraftRegistration = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftRegistration) && !is_string($aircraftRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aircraftRegistration)), __LINE__);
        }
        if (is_null($aircraftRegistration) || (is_array($aircraftRegistration) && empty($aircraftRegistration))) {
            unset($this->AircraftRegistration);
        } else {
            $this->AircraftRegistration = $aircraftRegistration;
        }
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirport()
    {
        return isset($this->ArrivalAirport) ? $this->ArrivalAirport : null;
    }
    /**
     * Set ArrivalAirport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirport
     * @return \StructType\FlightTouched
     */
    public function setArrivalAirport($arrivalAirport = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirport) && !is_string($arrivalAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalAirport)), __LINE__);
        }
        if (is_null($arrivalAirport) || (is_array($arrivalAirport) && empty($arrivalAirport))) {
            unset($this->ArrivalAirport);
        } else {
            $this->ArrivalAirport = $arrivalAirport;
        }
        return $this;
    }
    /**
     * Get CommercialFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommercialFlightNumber()
    {
        return isset($this->CommercialFlightNumber) ? $this->CommercialFlightNumber : null;
    }
    /**
     * Set CommercialFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commercialFlightNumber
     * @return \StructType\FlightTouched
     */
    public function setCommercialFlightNumber($commercialFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($commercialFlightNumber) && !is_string($commercialFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commercialFlightNumber)), __LINE__);
        }
        if (is_null($commercialFlightNumber) || (is_array($commercialFlightNumber) && empty($commercialFlightNumber))) {
            unset($this->CommercialFlightNumber);
        } else {
            $this->CommercialFlightNumber = $commercialFlightNumber;
        }
        return $this;
    }
    /**
     * Get DepartureAirport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirport()
    {
        return isset($this->DepartureAirport) ? $this->DepartureAirport : null;
    }
    /**
     * Set DepartureAirport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirport
     * @return \StructType\FlightTouched
     */
    public function setDepartureAirport($departureAirport = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirport) && !is_string($departureAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureAirport)), __LINE__);
        }
        if (is_null($departureAirport) || (is_array($departureAirport) && empty($departureAirport))) {
            unset($this->DepartureAirport);
        } else {
            $this->DepartureAirport = $departureAirport;
        }
        return $this;
    }
    /**
     * Get ExternalFlightId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalFlightId()
    {
        return isset($this->ExternalFlightId) ? $this->ExternalFlightId : null;
    }
    /**
     * Set ExternalFlightId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalFlightId
     * @return \StructType\FlightTouched
     */
    public function setExternalFlightId($externalFlightId = null)
    {
        // validation for constraint: string
        if (!is_null($externalFlightId) && !is_string($externalFlightId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalFlightId)), __LINE__);
        }
        if (is_null($externalFlightId) || (is_array($externalFlightId) && empty($externalFlightId))) {
            unset($this->ExternalFlightId);
        } else {
            $this->ExternalFlightId = $externalFlightId;
        }
        return $this;
    }
    /**
     * Get IcaoFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIcaoFlightNumber()
    {
        return isset($this->IcaoFlightNumber) ? $this->IcaoFlightNumber : null;
    }
    /**
     * Set IcaoFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $icaoFlightNumber
     * @return \StructType\FlightTouched
     */
    public function setIcaoFlightNumber($icaoFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($icaoFlightNumber) && !is_string($icaoFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($icaoFlightNumber)), __LINE__);
        }
        if (is_null($icaoFlightNumber) || (is_array($icaoFlightNumber) && empty($icaoFlightNumber))) {
            unset($this->IcaoFlightNumber);
        } else {
            $this->IcaoFlightNumber = $icaoFlightNumber;
        }
        return $this;
    }
    /**
     * Get ScheduledTimeOfDeparture value
     * @return string|null
     */
    public function getScheduledTimeOfDeparture()
    {
        return $this->ScheduledTimeOfDeparture;
    }
    /**
     * Set ScheduledTimeOfDeparture value
     * @param string $scheduledTimeOfDeparture
     * @return \StructType\FlightTouched
     */
    public function setScheduledTimeOfDeparture($scheduledTimeOfDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledTimeOfDeparture) && !is_string($scheduledTimeOfDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledTimeOfDeparture)), __LINE__);
        }
        $this->ScheduledTimeOfDeparture = $scheduledTimeOfDeparture;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightTouched
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
