<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Flight StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Flight
 * @subpackage Structs
 */
class Flight extends AbstractStructBase
{
    /**
     * The AircraftLoad
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLoad
     */
    public $AircraftLoad;
    /**
     * The AircraftRegistration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftRegistration;
    /**
     * The Airports
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirport
     */
    public $Airports;
    /**
     * The AutomaticProcessing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AutomaticProcessing;
    /**
     * The CommercialFlightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommercialFlightNumber;
    /**
     * The Crew
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCrew
     */
    public $Crew;
    /**
     * The EstimatedTimeOfDeparture
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedTimeOfDeparture;
    /**
     * The ExternalFlightId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalFlightId;
    /**
     * The IcaoFlightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IcaoFlightNumber;
    /**
     * The PassThroughValues
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPassThrough
     */
    public $PassThroughValues;
    /**
     * The Passengers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPax
     */
    public $Passengers;
    /**
     * The ScheduledTimeOfArrival
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledTimeOfArrival;
    /**
     * The ScheduledTimeOfDeparture
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledTimeOfDeparture;
    /**
     * The TypeOfFlight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TypeOfFlight;
    /**
     * Constructor method for Flight
     * @uses Flight::setAircraftLoad()
     * @uses Flight::setAircraftRegistration()
     * @uses Flight::setAirports()
     * @uses Flight::setAutomaticProcessing()
     * @uses Flight::setCommercialFlightNumber()
     * @uses Flight::setCrew()
     * @uses Flight::setEstimatedTimeOfDeparture()
     * @uses Flight::setExternalFlightId()
     * @uses Flight::setIcaoFlightNumber()
     * @uses Flight::setPassThroughValues()
     * @uses Flight::setPassengers()
     * @uses Flight::setScheduledTimeOfArrival()
     * @uses Flight::setScheduledTimeOfDeparture()
     * @uses Flight::setTypeOfFlight()
     * @param \ArrayType\ArrayOfLoad $aircraftLoad
     * @param string $aircraftRegistration
     * @param \ArrayType\ArrayOfAirport $airports
     * @param bool $automaticProcessing
     * @param string $commercialFlightNumber
     * @param \ArrayType\ArrayOfCrew $crew
     * @param string $estimatedTimeOfDeparture
     * @param string $externalFlightId
     * @param string $icaoFlightNumber
     * @param \ArrayType\ArrayOfPassThrough $passThroughValues
     * @param \ArrayType\ArrayOfPax $passengers
     * @param string $scheduledTimeOfArrival
     * @param string $scheduledTimeOfDeparture
     * @param string $typeOfFlight
     */
    public function __construct(\ArrayType\ArrayOfLoad $aircraftLoad = null, $aircraftRegistration = null, \ArrayType\ArrayOfAirport $airports = null, $automaticProcessing = null, $commercialFlightNumber = null, \ArrayType\ArrayOfCrew $crew = null, $estimatedTimeOfDeparture = null, $externalFlightId = null, $icaoFlightNumber = null, \ArrayType\ArrayOfPassThrough $passThroughValues = null, \ArrayType\ArrayOfPax $passengers = null, $scheduledTimeOfArrival = null, $scheduledTimeOfDeparture = null, $typeOfFlight = null)
    {
        $this
            ->setAircraftLoad($aircraftLoad)
            ->setAircraftRegistration($aircraftRegistration)
            ->setAirports($airports)
            ->setAutomaticProcessing($automaticProcessing)
            ->setCommercialFlightNumber($commercialFlightNumber)
            ->setCrew($crew)
            ->setEstimatedTimeOfDeparture($estimatedTimeOfDeparture)
            ->setExternalFlightId($externalFlightId)
            ->setIcaoFlightNumber($icaoFlightNumber)
            ->setPassThroughValues($passThroughValues)
            ->setPassengers($passengers)
            ->setScheduledTimeOfArrival($scheduledTimeOfArrival)
            ->setScheduledTimeOfDeparture($scheduledTimeOfDeparture)
            ->setTypeOfFlight($typeOfFlight);
    }
    /**
     * Get AircraftLoad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLoad|null
     */
    public function getAircraftLoad()
    {
        return isset($this->AircraftLoad) ? $this->AircraftLoad : null;
    }
    /**
     * Set AircraftLoad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLoad $aircraftLoad
     * @return \StructType\Flight
     */
    public function setAircraftLoad(\ArrayType\ArrayOfLoad $aircraftLoad = null)
    {
        if (is_null($aircraftLoad) || (is_array($aircraftLoad) && empty($aircraftLoad))) {
            unset($this->AircraftLoad);
        } else {
            $this->AircraftLoad = $aircraftLoad;
        }
        return $this;
    }
    /**
     * Get AircraftRegistration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftRegistration()
    {
        return isset($this->AircraftRegistration) ? $this->AircraftRegistration : null;
    }
    /**
     * Set AircraftRegistration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftRegistration
     * @return \StructType\Flight
     */
    public function setAircraftRegistration($aircraftRegistration = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftRegistration) && !is_string($aircraftRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aircraftRegistration)), __LINE__);
        }
        if (is_null($aircraftRegistration) || (is_array($aircraftRegistration) && empty($aircraftRegistration))) {
            unset($this->AircraftRegistration);
        } else {
            $this->AircraftRegistration = $aircraftRegistration;
        }
        return $this;
    }
    /**
     * Get Airports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirport|null
     */
    public function getAirports()
    {
        return isset($this->Airports) ? $this->Airports : null;
    }
    /**
     * Set Airports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirport $airports
     * @return \StructType\Flight
     */
    public function setAirports(\ArrayType\ArrayOfAirport $airports = null)
    {
        if (is_null($airports) || (is_array($airports) && empty($airports))) {
            unset($this->Airports);
        } else {
            $this->Airports = $airports;
        }
        return $this;
    }
    /**
     * Get AutomaticProcessing value
     * @return bool|null
     */
    public function getAutomaticProcessing()
    {
        return $this->AutomaticProcessing;
    }
    /**
     * Set AutomaticProcessing value
     * @param bool $automaticProcessing
     * @return \StructType\Flight
     */
    public function setAutomaticProcessing($automaticProcessing = null)
    {
        // validation for constraint: boolean
        if (!is_null($automaticProcessing) && !is_bool($automaticProcessing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($automaticProcessing)), __LINE__);
        }
        $this->AutomaticProcessing = $automaticProcessing;
        return $this;
    }
    /**
     * Get CommercialFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommercialFlightNumber()
    {
        return isset($this->CommercialFlightNumber) ? $this->CommercialFlightNumber : null;
    }
    /**
     * Set CommercialFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commercialFlightNumber
     * @return \StructType\Flight
     */
    public function setCommercialFlightNumber($commercialFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($commercialFlightNumber) && !is_string($commercialFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commercialFlightNumber)), __LINE__);
        }
        if (is_null($commercialFlightNumber) || (is_array($commercialFlightNumber) && empty($commercialFlightNumber))) {
            unset($this->CommercialFlightNumber);
        } else {
            $this->CommercialFlightNumber = $commercialFlightNumber;
        }
        return $this;
    }
    /**
     * Get Crew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCrew|null
     */
    public function getCrew()
    {
        return isset($this->Crew) ? $this->Crew : null;
    }
    /**
     * Set Crew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCrew $crew
     * @return \StructType\Flight
     */
    public function setCrew(\ArrayType\ArrayOfCrew $crew = null)
    {
        if (is_null($crew) || (is_array($crew) && empty($crew))) {
            unset($this->Crew);
        } else {
            $this->Crew = $crew;
        }
        return $this;
    }
    /**
     * Get EstimatedTimeOfDeparture value
     * @return string|null
     */
    public function getEstimatedTimeOfDeparture()
    {
        return $this->EstimatedTimeOfDeparture;
    }
    /**
     * Set EstimatedTimeOfDeparture value
     * @param string $estimatedTimeOfDeparture
     * @return \StructType\Flight
     */
    public function setEstimatedTimeOfDeparture($estimatedTimeOfDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedTimeOfDeparture) && !is_string($estimatedTimeOfDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedTimeOfDeparture)), __LINE__);
        }
        $this->EstimatedTimeOfDeparture = $estimatedTimeOfDeparture;
        return $this;
    }
    /**
     * Get ExternalFlightId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalFlightId()
    {
        return isset($this->ExternalFlightId) ? $this->ExternalFlightId : null;
    }
    /**
     * Set ExternalFlightId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalFlightId
     * @return \StructType\Flight
     */
    public function setExternalFlightId($externalFlightId = null)
    {
        // validation for constraint: string
        if (!is_null($externalFlightId) && !is_string($externalFlightId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalFlightId)), __LINE__);
        }
        if (is_null($externalFlightId) || (is_array($externalFlightId) && empty($externalFlightId))) {
            unset($this->ExternalFlightId);
        } else {
            $this->ExternalFlightId = $externalFlightId;
        }
        return $this;
    }
    /**
     * Get IcaoFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIcaoFlightNumber()
    {
        return isset($this->IcaoFlightNumber) ? $this->IcaoFlightNumber : null;
    }
    /**
     * Set IcaoFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $icaoFlightNumber
     * @return \StructType\Flight
     */
    public function setIcaoFlightNumber($icaoFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($icaoFlightNumber) && !is_string($icaoFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($icaoFlightNumber)), __LINE__);
        }
        if (is_null($icaoFlightNumber) || (is_array($icaoFlightNumber) && empty($icaoFlightNumber))) {
            unset($this->IcaoFlightNumber);
        } else {
            $this->IcaoFlightNumber = $icaoFlightNumber;
        }
        return $this;
    }
    /**
     * Get PassThroughValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPassThrough|null
     */
    public function getPassThroughValues()
    {
        return isset($this->PassThroughValues) ? $this->PassThroughValues : null;
    }
    /**
     * Set PassThroughValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPassThrough $passThroughValues
     * @return \StructType\Flight
     */
    public function setPassThroughValues(\ArrayType\ArrayOfPassThrough $passThroughValues = null)
    {
        if (is_null($passThroughValues) || (is_array($passThroughValues) && empty($passThroughValues))) {
            unset($this->PassThroughValues);
        } else {
            $this->PassThroughValues = $passThroughValues;
        }
        return $this;
    }
    /**
     * Get Passengers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPax|null
     */
    public function getPassengers()
    {
        return isset($this->Passengers) ? $this->Passengers : null;
    }
    /**
     * Set Passengers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPax $passengers
     * @return \StructType\Flight
     */
    public function setPassengers(\ArrayType\ArrayOfPax $passengers = null)
    {
        if (is_null($passengers) || (is_array($passengers) && empty($passengers))) {
            unset($this->Passengers);
        } else {
            $this->Passengers = $passengers;
        }
        return $this;
    }
    /**
     * Get ScheduledTimeOfArrival value
     * @return string|null
     */
    public function getScheduledTimeOfArrival()
    {
        return $this->ScheduledTimeOfArrival;
    }
    /**
     * Set ScheduledTimeOfArrival value
     * @param string $scheduledTimeOfArrival
     * @return \StructType\Flight
     */
    public function setScheduledTimeOfArrival($scheduledTimeOfArrival = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledTimeOfArrival) && !is_string($scheduledTimeOfArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledTimeOfArrival)), __LINE__);
        }
        $this->ScheduledTimeOfArrival = $scheduledTimeOfArrival;
        return $this;
    }
    /**
     * Get ScheduledTimeOfDeparture value
     * @return string|null
     */
    public function getScheduledTimeOfDeparture()
    {
        return $this->ScheduledTimeOfDeparture;
    }
    /**
     * Set ScheduledTimeOfDeparture value
     * @param string $scheduledTimeOfDeparture
     * @return \StructType\Flight
     */
    public function setScheduledTimeOfDeparture($scheduledTimeOfDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledTimeOfDeparture) && !is_string($scheduledTimeOfDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledTimeOfDeparture)), __LINE__);
        }
        $this->ScheduledTimeOfDeparture = $scheduledTimeOfDeparture;
        return $this;
    }
    /**
     * Get TypeOfFlight value
     * @return string|null
     */
    public function getTypeOfFlight()
    {
        return $this->TypeOfFlight;
    }
    /**
     * Set TypeOfFlight value
     * @uses \EnumType\ATCFlightType::valueIsValid()
     * @uses \EnumType\ATCFlightType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfFlight
     * @return \StructType\Flight
     */
    public function setTypeOfFlight($typeOfFlight = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ATCFlightType::valueIsValid($typeOfFlight)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $typeOfFlight, implode(', ', \EnumType\ATCFlightType::getValidValues())), __LINE__);
        }
        $this->TypeOfFlight = $typeOfFlight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Flight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
