<?php

namespace EnumType;

/**
 * This class stands for LoadType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LoadType
 * @subpackage Enumerations
 */
class LoadType
{
    /**
     * Constant for value 'ZeroFuelMass'
     * @return string 'ZeroFuelMass'
     */
    const VALUE_ZERO_FUEL_MASS = 'ZeroFuelMass';
    /**
     * Constant for value 'Cargo'
     * @return string 'Cargo'
     */
    const VALUE_CARGO = 'Cargo';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ZERO_FUEL_MASS
     * @uses self::VALUE_CARGO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ZERO_FUEL_MASS,
            self::VALUE_CARGO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
