<?php

namespace EnumType;

/**
 * This class stands for AirportType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AirportType
 * @subpackage Enumerations
 */
class AirportType
{
    /**
     * Constant for value 'Departure'
     * @return string 'Departure'
     */
    const VALUE_DEPARTURE = 'Departure';
    /**
     * Constant for value 'Arrival'
     * @return string 'Arrival'
     */
    const VALUE_ARRIVAL = 'Arrival';
    /**
     * Constant for value 'PrimaryArrivalAlternate'
     * @return string 'PrimaryArrivalAlternate'
     */
    const VALUE_PRIMARY_ARRIVAL_ALTERNATE = 'PrimaryArrivalAlternate';
    /**
     * Constant for value 'ArrivalAlternate'
     * @return string 'ArrivalAlternate'
     */
    const VALUE_ARRIVAL_ALTERNATE = 'ArrivalAlternate';
    /**
     * Constant for value 'DepartureAlternate'
     * @return string 'DepartureAlternate'
     */
    const VALUE_DEPARTURE_ALTERNATE = 'DepartureAlternate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEPARTURE
     * @uses self::VALUE_ARRIVAL
     * @uses self::VALUE_PRIMARY_ARRIVAL_ALTERNATE
     * @uses self::VALUE_ARRIVAL_ALTERNATE
     * @uses self::VALUE_DEPARTURE_ALTERNATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEPARTURE,
            self::VALUE_ARRIVAL,
            self::VALUE_PRIMARY_ARRIVAL_ALTERNATE,
            self::VALUE_ARRIVAL_ALTERNATE,
            self::VALUE_DEPARTURE_ALTERNATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
