<?php

namespace EnumType;

/**
 * This class stands for ATCFlightType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ATCFlightType
 * @subpackage Enumerations
 */
class ATCFlightType
{
    /**
     * Constant for value 'NotSpecified'
     * @return string 'NotSpecified'
     */
    const VALUE_NOT_SPECIFIED = 'NotSpecified';
    /**
     * Constant for value 'ScheduledAirTransportFlight'
     * @return string 'ScheduledAirTransportFlight'
     */
    const VALUE_SCHEDULED_AIR_TRANSPORT_FLIGHT = 'ScheduledAirTransportFlight';
    /**
     * Constant for value 'NonScheduledAirTransportFlight'
     * @return string 'NonScheduledAirTransportFlight'
     */
    const VALUE_NON_SCHEDULED_AIR_TRANSPORT_FLIGHT = 'NonScheduledAirTransportFlight';
    /**
     * Constant for value 'GeneralAviation'
     * @return string 'GeneralAviation'
     */
    const VALUE_GENERAL_AVIATION = 'GeneralAviation';
    /**
     * Constant for value 'Military'
     * @return string 'Military'
     */
    const VALUE_MILITARY = 'Military';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SPECIFIED
     * @uses self::VALUE_SCHEDULED_AIR_TRANSPORT_FLIGHT
     * @uses self::VALUE_NON_SCHEDULED_AIR_TRANSPORT_FLIGHT
     * @uses self::VALUE_GENERAL_AVIATION
     * @uses self::VALUE_MILITARY
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SPECIFIED,
            self::VALUE_SCHEDULED_AIR_TRANSPORT_FLIGHT,
            self::VALUE_NON_SCHEDULED_AIR_TRANSPORT_FLIGHT,
            self::VALUE_GENERAL_AVIATION,
            self::VALUE_MILITARY,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
