<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPax ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPax
 * @subpackage Arrays
 */
class ArrayOfPax extends AbstractStructArrayBase
{
    /**
     * The Pax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Pax[]
     */
    public $Pax;
    /**
     * Constructor method for ArrayOfPax
     * @uses ArrayOfPax::setPax()
     * @param \StructType\Pax[] $pax
     */
    public function __construct(array $pax = array())
    {
        $this
            ->setPax($pax);
    }
    /**
     * Get Pax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Pax[]|null
     */
    public function getPax()
    {
        return isset($this->Pax) ? $this->Pax : null;
    }
    /**
     * Set Pax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Pax[] $pax
     * @return \ArrayType\ArrayOfPax
     */
    public function setPax(array $pax = array())
    {
        foreach ($pax as $arrayOfPaxPaxItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaxPaxItem instanceof \StructType\Pax) {
                throw new \InvalidArgumentException(sprintf('The Pax property can only contain items of \StructType\Pax, "%s" given', is_object($arrayOfPaxPaxItem) ? get_class($arrayOfPaxPaxItem) : gettype($arrayOfPaxPaxItem)), __LINE__);
            }
        }
        if (is_null($pax) || (is_array($pax) && empty($pax))) {
            unset($this->Pax);
        } else {
            $this->Pax = $pax;
        }
        return $this;
    }
    /**
     * Add item to Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\Pax $item
     * @return \ArrayType\ArrayOfPax
     */
    public function addToPax(\StructType\Pax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pax) {
            throw new \InvalidArgumentException(sprintf('The Pax property can only contain items of \StructType\Pax, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Pax[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Pax|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Pax|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Pax|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Pax|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Pax|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Pax
     */
    public function getAttributeName()
    {
        return 'Pax';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
