<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLoad ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLoad
 * @subpackage Arrays
 */
class ArrayOfLoad extends AbstractStructArrayBase
{
    /**
     * The Load
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Load[]
     */
    public $Load;
    /**
     * Constructor method for ArrayOfLoad
     * @uses ArrayOfLoad::setLoad()
     * @param \StructType\Load[] $load
     */
    public function __construct(array $load = array())
    {
        $this
            ->setLoad($load);
    }
    /**
     * Get Load value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Load[]|null
     */
    public function getLoad()
    {
        return isset($this->Load) ? $this->Load : null;
    }
    /**
     * Set Load value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Load[] $load
     * @return \ArrayType\ArrayOfLoad
     */
    public function setLoad(array $load = array())
    {
        foreach ($load as $arrayOfLoadLoadItem) {
            // validation for constraint: itemType
            if (!$arrayOfLoadLoadItem instanceof \StructType\Load) {
                throw new \InvalidArgumentException(sprintf('The Load property can only contain items of \StructType\Load, "%s" given', is_object($arrayOfLoadLoadItem) ? get_class($arrayOfLoadLoadItem) : gettype($arrayOfLoadLoadItem)), __LINE__);
            }
        }
        if (is_null($load) || (is_array($load) && empty($load))) {
            unset($this->Load);
        } else {
            $this->Load = $load;
        }
        return $this;
    }
    /**
     * Add item to Load value
     * @throws \InvalidArgumentException
     * @param \StructType\Load $item
     * @return \ArrayType\ArrayOfLoad
     */
    public function addToLoad(\StructType\Load $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Load) {
            throw new \InvalidArgumentException(sprintf('The Load property can only contain items of \StructType\Load, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Load[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Load|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Load|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Load|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Load|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Load|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Load
     */
    public function getAttributeName()
    {
        return 'Load';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfLoad
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
