<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFlight ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfFlight
 * @subpackage Arrays
 */
class ArrayOfFlight extends AbstractStructArrayBase
{
    /**
     * The Flight
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Flight[]
     */
    public $Flight;
    /**
     * Constructor method for ArrayOfFlight
     * @uses ArrayOfFlight::setFlight()
     * @param \StructType\Flight[] $flight
     */
    public function __construct(array $flight = array())
    {
        $this
            ->setFlight($flight);
    }
    /**
     * Get Flight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Flight[]|null
     */
    public function getFlight()
    {
        return isset($this->Flight) ? $this->Flight : null;
    }
    /**
     * Set Flight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Flight[] $flight
     * @return \ArrayType\ArrayOfFlight
     */
    public function setFlight(array $flight = array())
    {
        foreach ($flight as $arrayOfFlightFlightItem) {
            // validation for constraint: itemType
            if (!$arrayOfFlightFlightItem instanceof \StructType\Flight) {
                throw new \InvalidArgumentException(sprintf('The Flight property can only contain items of \StructType\Flight, "%s" given', is_object($arrayOfFlightFlightItem) ? get_class($arrayOfFlightFlightItem) : gettype($arrayOfFlightFlightItem)), __LINE__);
            }
        }
        if (is_null($flight) || (is_array($flight) && empty($flight))) {
            unset($this->Flight);
        } else {
            $this->Flight = $flight;
        }
        return $this;
    }
    /**
     * Add item to Flight value
     * @throws \InvalidArgumentException
     * @param \StructType\Flight $item
     * @return \ArrayType\ArrayOfFlight
     */
    public function addToFlight(\StructType\Flight $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Flight) {
            throw new \InvalidArgumentException(sprintf('The Flight property can only contain items of \StructType\Flight, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Flight[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Flight|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Flight|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Flight|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Flight|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Flight|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Flight
     */
    public function getAttributeName()
    {
        return 'Flight';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFlight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
