<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightCollection StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightCollection
 * @subpackage Structs
 */
class FlightCollection extends AbstractStructBase
{
    /**
     * The Flight
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Flight[]
     */
    public $Flight;
    /**
     * Constructor method for FlightCollection
     * @uses FlightCollection::setFlight()
     * @param \StructType\Flight[] $flight
     */
    public function __construct(array $flight = array())
    {
        $this
            ->setFlight($flight);
    }
    /**
     * Get Flight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Flight[]|null
     */
    public function getFlight()
    {
        return isset($this->Flight) ? $this->Flight : null;
    }
    /**
     * Set Flight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Flight[] $flight
     * @return \StructType\FlightCollection
     */
    public function setFlight(array $flight = array())
    {
        foreach ($flight as $flightCollectionFlightItem) {
            // validation for constraint: itemType
            if (!$flightCollectionFlightItem instanceof \StructType\Flight) {
                throw new \InvalidArgumentException(sprintf('The Flight property can only contain items of \StructType\Flight, "%s" given', is_object($flightCollectionFlightItem) ? get_class($flightCollectionFlightItem) : gettype($flightCollectionFlightItem)), __LINE__);
            }
        }
        if (is_null($flight) || (is_array($flight) && empty($flight))) {
            unset($this->Flight);
        } else {
            $this->Flight = $flight;
        }
        return $this;
    }
    /**
     * Add item to Flight value
     * @throws \InvalidArgumentException
     * @param \StructType\Flight $item
     * @return \StructType\FlightCollection
     */
    public function addToFlight(\StructType\Flight $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Flight) {
            throw new \InvalidArgumentException(sprintf('The Flight property can only contain items of \StructType\Flight, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Flight[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
