<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Airport StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Airport
 * @subpackage Structs
 */
class Airport extends AbstractStructBase
{
    /**
     * The Icao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Icao;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Airport
     * @uses Airport::setIcao()
     * @uses Airport::setType()
     * @param string $icao
     * @param string $type
     */
    public function __construct($icao = null, $type = null)
    {
        $this
            ->setIcao($icao)
            ->setType($type);
    }
    /**
     * Get Icao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIcao()
    {
        return isset($this->Icao) ? $this->Icao : null;
    }
    /**
     * Set Icao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $icao
     * @return \StructType\Airport
     */
    public function setIcao($icao = null)
    {
        // validation for constraint: string
        if (!is_null($icao) && !is_string($icao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($icao)), __LINE__);
        }
        if (is_null($icao) || (is_array($icao) && empty($icao))) {
            unset($this->Icao);
        } else {
            $this->Icao = $icao;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\AirportType::valueIsValid()
     * @uses \EnumType\AirportType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Airport
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirportType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\AirportType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Airport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
