<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload ServiceType
 * @subpackage Services
 */
class Upload extends AbstractSoapClientBase
{
    /**
     * Sets the PPSCustomer SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param PPSCustomer $pPSCustomer
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPPSCustomer(PPSCustomer $pPSCustomer, $nameSpace = 'http://www.airsupport.dk/scheduledflight', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'PPSCustomer', $pPSCustomer, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UploadScheduledFlights
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: PPSCustomer
     * - SOAPHeaderNamespaces: http://www.airsupport.dk/scheduledflight
     * - SOAPHeaderTypes: PPSCustomer
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadScheduledFlights $parameters
     * @return \StructType\UploadScheduledFlightsResponse|bool
     */
    public function UploadScheduledFlights(\StructType\UploadScheduledFlights $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UploadScheduledFlights($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UploadScheduledFlightsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
