<?php

namespace EnumType;

/**
 * This class stands for LoadUnit EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LoadUnit
 * @subpackage Enumerations
 */
class LoadUnit
{
    /**
     * Constant for value 'Kilo'
     * @return string 'Kilo'
     */
    const VALUE_KILO = 'Kilo';
    /**
     * Constant for value 'Pound'
     * @return string 'Pound'
     */
    const VALUE_POUND = 'Pound';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KILO
     * @uses self::VALUE_POUND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KILO,
            self::VALUE_POUND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
