<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCrew ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCrew
 * @subpackage Arrays
 */
class ArrayOfCrew extends AbstractStructArrayBase
{
    /**
     * The Crew
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Crew[]
     */
    public $Crew;
    /**
     * Constructor method for ArrayOfCrew
     * @uses ArrayOfCrew::setCrew()
     * @param \StructType\Crew[] $crew
     */
    public function __construct(array $crew = array())
    {
        $this
            ->setCrew($crew);
    }
    /**
     * Get Crew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Crew[]|null
     */
    public function getCrew()
    {
        return isset($this->Crew) ? $this->Crew : null;
    }
    /**
     * Set Crew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Crew[] $crew
     * @return \ArrayType\ArrayOfCrew
     */
    public function setCrew(array $crew = array())
    {
        foreach ($crew as $arrayOfCrewCrewItem) {
            // validation for constraint: itemType
            if (!$arrayOfCrewCrewItem instanceof \StructType\Crew) {
                throw new \InvalidArgumentException(sprintf('The Crew property can only contain items of \StructType\Crew, "%s" given', is_object($arrayOfCrewCrewItem) ? get_class($arrayOfCrewCrewItem) : gettype($arrayOfCrewCrewItem)), __LINE__);
            }
        }
        if (is_null($crew) || (is_array($crew) && empty($crew))) {
            unset($this->Crew);
        } else {
            $this->Crew = $crew;
        }
        return $this;
    }
    /**
     * Add item to Crew value
     * @throws \InvalidArgumentException
     * @param \StructType\Crew $item
     * @return \ArrayType\ArrayOfCrew
     */
    public function addToCrew(\StructType\Crew $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Crew) {
            throw new \InvalidArgumentException(sprintf('The Crew property can only contain items of \StructType\Crew, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Crew[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Crew|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Crew|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Crew|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Crew|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Crew|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Crew
     */
    public function getAttributeName()
    {
        return 'Crew';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCrew
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
