<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_List StructType
 * @subpackage Structs
 */
class Item_List extends AbstractStructBase
{
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Item[]
     */
    public $Item;
    /**
     * Constructor method for Item_List
     * @uses Item_List::setItem()
     * @param \StructType\Item[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get Item value
     * @return \StructType\Item[]
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item[] $item
     * @return \StructType\Item_List
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $item_ListItemItem) {
            // validation for constraint: itemType
            if (!$item_ListItemItem instanceof \StructType\Item) {
                throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \StructType\Item, "%s" given', is_object($item_ListItemItem) ? get_class($item_ListItemItem) : gettype($item_ListItemItem)), __LINE__);
            }
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item $item
     * @return \StructType\Item_List
     */
    public function addToItem(\StructType\Item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \StructType\Item, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Item_List
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
