<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Filter StructType
 * @subpackage Structs
 */
class Item_Filter extends AbstractStructBase
{
    /**
     * The Field
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Field;
    /**
     * The Criteria
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Criteria;
    /**
     * Constructor method for Item_Filter
     * @uses Item_Filter::setField()
     * @uses Item_Filter::setCriteria()
     * @param string $field
     * @param string $criteria
     */
    public function __construct($field = null, $criteria = null)
    {
        $this
            ->setField($field)
            ->setCriteria($criteria);
    }
    /**
     * Get Field value
     * @return string
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * Set Field value
     * @uses \EnumType\Item_Fields::valueIsValid()
     * @uses \EnumType\Item_Fields::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $field
     * @return \StructType\Item_Filter
     */
    public function setField($field = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Item_Fields::valueIsValid($field)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $field, implode(', ', \EnumType\Item_Fields::getValidValues())), __LINE__);
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Get Criteria value
     * @return string
     */
    public function getCriteria()
    {
        return $this->Criteria;
    }
    /**
     * Set Criteria value
     * @param string $criteria
     * @return \StructType\Item_Filter
     */
    public function setCriteria($criteria = null)
    {
        // validation for constraint: string
        if (!is_null($criteria) && !is_string($criteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($criteria)), __LINE__);
        }
        $this->Criteria = $criteria;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Item_Filter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
