<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadMultiple StructType
 * @subpackage Structs
 */
class ReadMultiple extends AbstractStructBase
{
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Item_Filter[]
     */
    public $filter;
    /**
     * The setSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $setSize;
    /**
     * The bookmarkKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bookmarkKey;
    /**
     * Constructor method for ReadMultiple
     * @uses ReadMultiple::setFilter()
     * @uses ReadMultiple::setSetSize()
     * @uses ReadMultiple::setBookmarkKey()
     * @param \StructType\Item_Filter[] $filter
     * @param int $setSize
     * @param string $bookmarkKey
     */
    public function __construct(array $filter = array(), $setSize = null, $bookmarkKey = null)
    {
        $this
            ->setFilter($filter)
            ->setSetSize($setSize)
            ->setBookmarkKey($bookmarkKey);
    }
    /**
     * Get filter value
     * @return \StructType\Item_Filter[]
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Filter[] $filter
     * @return \StructType\ReadMultiple
     */
    public function setFilter(array $filter = array())
    {
        foreach ($filter as $readMultipleFilterItem) {
            // validation for constraint: itemType
            if (!$readMultipleFilterItem instanceof \StructType\Item_Filter) {
                throw new \InvalidArgumentException(sprintf('The filter property can only contain items of \StructType\Item_Filter, "%s" given', is_object($readMultipleFilterItem) ? get_class($readMultipleFilterItem) : gettype($readMultipleFilterItem)), __LINE__);
            }
        }
        $this->filter = $filter;
        return $this;
    }
    /**
     * Add item to filter value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Filter $item
     * @return \StructType\ReadMultiple
     */
    public function addToFilter(\StructType\Item_Filter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Filter) {
            throw new \InvalidArgumentException(sprintf('The filter property can only contain items of \StructType\Item_Filter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->filter[] = $item;
        return $this;
    }
    /**
     * Get setSize value
     * @return int
     */
    public function getSetSize()
    {
        return $this->setSize;
    }
    /**
     * Set setSize value
     * @param int $setSize
     * @return \StructType\ReadMultiple
     */
    public function setSetSize($setSize = null)
    {
        // validation for constraint: int
        if (!is_null($setSize) && !is_numeric($setSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($setSize)), __LINE__);
        }
        $this->setSize = $setSize;
        return $this;
    }
    /**
     * Get bookmarkKey value
     * @return string|null
     */
    public function getBookmarkKey()
    {
        return $this->bookmarkKey;
    }
    /**
     * Set bookmarkKey value
     * @param string $bookmarkKey
     * @return \StructType\ReadMultiple
     */
    public function setBookmarkKey($bookmarkKey = null)
    {
        // validation for constraint: string
        if (!is_null($bookmarkKey) && !is_string($bookmarkKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookmarkKey)), __LINE__);
        }
        $this->bookmarkKey = $bookmarkKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReadMultiple
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
