<?php

namespace EnumType;

/**
 * This class stands for Current_E_Com_Sales_Type EnumType
 * @subpackage Enumerations
 */
class Current_E_Com_Sales_Type
{
    /**
     * Constant for value 'E_Com_Campaingn'
     * @return string 'E_Com_Campaingn'
     */
    const VALUE_E_COM_CAMPAINGN = 'E_Com_Campaingn';
    /**
     * Constant for value 'Season'
     * @return string 'Season'
     */
    const VALUE_SEASON = 'Season';
    /**
     * Constant for value 'No_Sale'
     * @return string 'No_Sale'
     */
    const VALUE_NO_SALE = 'No_Sale';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E_COM_CAMPAINGN
     * @uses self::VALUE_SEASON
     * @uses self::VALUE_NO_SALE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E_COM_CAMPAINGN,
            self::VALUE_SEASON,
            self::VALUE_NO_SALE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
