<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadByRecId StructType
 * @subpackage Structs
 */
class ReadByRecId extends AbstractStructBase
{
    /**
     * The recId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $recId;
    /**
     * Constructor method for ReadByRecId
     * @uses ReadByRecId::setRecId()
     * @param string $recId
     */
    public function __construct($recId = null)
    {
        $this
            ->setRecId($recId);
    }
    /**
     * Get recId value
     * @return string
     */
    public function getRecId()
    {
        return $this->recId;
    }
    /**
     * Set recId value
     * @param string $recId
     * @return \StructType\ReadByRecId
     */
    public function setRecId($recId = null)
    {
        // validation for constraint: string
        if (!is_null($recId) && !is_string($recId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recId)), __LINE__);
        }
        $this->recId = $recId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReadByRecId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
